/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import com.sun.imageio.plugins.common.BogusColorSpace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageTypeSpecifier;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.info.RasterQueryInfo;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ComponentColorModelJAI;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasterUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");

    private RasterUtils() {
    }

    private static GridEnvelope findMatchingTiles(Dimension tileSize, int numTilesWide, int numTilesHigh, GridEnvelope pixelRange) {
        int minPixelX = pixelRange.getLow(0);
        int minPixelY = pixelRange.getLow(1);
        int minTileX = (int)Math.floor((double)minPixelX / tileSize.getWidth());
        int minTileY = (int)Math.floor((double)minPixelY / tileSize.getHeight());
        int numTilesX = (int)Math.ceil((double)pixelRange.getSpan(0) / tileSize.getWidth());
        int numTilesY = (int)Math.ceil((double)pixelRange.getSpan(1) / tileSize.getHeight());
        int maxTiledX = (minTileX + numTilesX) * tileSize.width;
        int maxTiledY = (minTileY + numTilesY) * tileSize.height;
        if (maxTiledX < pixelRange.getHigh(0) && minTileX + numTilesX < numTilesWide) {
            ++numTilesX;
        }
        if (maxTiledY < pixelRange.getHigh(1) && minTileY + numTilesY < numTilesHigh) {
            ++numTilesY;
        }
        GridEnvelope2D matchingTiles = new GridEnvelope2D(minTileX, minTileY, numTilesX, numTilesY);
        return matchingTiles;
    }

    private static GridEnvelope getTargetGridRange(MathTransform modelToRaster, Envelope requestedEnvelope) {
        GeneralEnvelope requestedPixels;
        try {
            requestedPixels = CRS.transform((MathTransform)modelToRaster, (Envelope)requestedEnvelope);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(e);
        }
        int levelMinPixelX = (int)Math.floor(requestedPixels.getMinimum(0));
        int levelMinPixelY = (int)Math.floor(requestedPixels.getMinimum(1));
        int levelMaxPixelX = (int)Math.ceil(requestedPixels.getMaximum(0));
        int levelMaxPixelY = (int)Math.ceil(requestedPixels.getMaximum(1));
        int width = levelMaxPixelX - levelMinPixelX;
        int height = levelMaxPixelY - levelMinPixelY;
        GridEnvelope2D levelOverlappingPixels = new GridEnvelope2D(levelMinPixelX, levelMinPixelY, width, height);
        return levelOverlappingPixels;
    }

    public static IndexColorModel sdeColorMapToJavaColorModel(DataBuffer colorMapData, int bitsPerSample) {
        if (colorMapData == null) {
            throw new NullPointerException("colorMapData");
        }
        if (colorMapData.getNumBanks() < 3 || colorMapData.getNumBanks() > 4) {
            throw new IllegalArgumentException("colorMapData shall have 3 or 4 banks: " + colorMapData.getNumBanks());
        }
        if (bitsPerSample != 8 && bitsPerSample != 16) {
            throw new IllegalAccessError("bits per sample shall be either 8 or 16. Got " + bitsPerSample);
        }
        int numBanks = colorMapData.getNumBanks();
        int mapSize = colorMapData.getSize();
        byte[] r = new byte[mapSize];
        byte[] g = new byte[mapSize];
        byte[] b = new byte[mapSize];
        byte[] a = new byte[mapSize];
        for (int i = 0; i < mapSize; ++i) {
            r[i] = (byte)(colorMapData.getElem(0, i) & 0xFF);
            g[i] = (byte)(colorMapData.getElem(1, i) & 0xFF);
            b[i] = (byte)(colorMapData.getElem(2, i) & 0xFF);
            a[i] = (byte)((numBanks == 3 ? 255 : colorMapData.getElem(3, i)) & 0xFF);
        }
        IndexColorModel colorModel = new IndexColorModel(bitsPerSample, mapSize, r, g, b, a);
        return colorModel;
    }

    public static ImageTypeSpecifier createFullImageTypeSpecifier(RasterDatasetInfo rasterInfo, int rasterIndex) {
        ImageTypeSpecifier its;
        int numberOfBands = rasterInfo.getNumBands();
        RasterCellType nativePixelType = rasterInfo.getNativeCellType();
        RasterCellType pixelType = rasterInfo.getTargetCellType(rasterIndex);
        boolean sampleImageWidth = true;
        boolean sampleImageHeight = true;
        int bitsPerSample = pixelType.getBitsPerSample();
        int dataType = pixelType.getDataBufferType();
        boolean hasColorMap = rasterInfo.isColorMapped();
        if (hasColorMap) {
            IndexColorModel colorMap = rasterInfo.getColorMap(rasterIndex);
            its = RasterUtils.createColorMappedImageSpec(colorMap, 1, 1);
        } else if (nativePixelType == RasterCellType.TYPE_1BIT && numberOfBands == 1) {
            byte noDataValue = rasterInfo.getNoDataValue(rasterIndex, 0).byteValue();
            its = RasterUtils.createOneBitColorMappedImageSpec(1, 1, noDataValue);
        } else if (nativePixelType == RasterCellType.TYPE_4BIT && numberOfBands == 1) {
            byte noDataValue = rasterInfo.getNoDataValue(rasterIndex, 0).byteValue();
            its = RasterUtils.createFourBitColorMappedImageSpec(1, 1, noDataValue);
        } else if (numberOfBands == 1) {
            its = RasterUtils.createGrayscaleImageSpec(1, 1, dataType, bitsPerSample);
        } else if (numberOfBands == 3 && pixelType == RasterCellType.TYPE_8BIT_U) {
            its = RasterUtils.createRGBImageSpec(1, 1, dataType);
        } else if (numberOfBands == 4 && pixelType == RasterCellType.TYPE_8BIT_U) {
            its = RasterUtils.createRGBAImageSpec(1, 1, dataType);
        } else {
            int i;
            BogusColorSpace colorSpace = new BogusColorSpace(numberOfBands);
            int[] numBits = new int[numberOfBands];
            for (i = 0; i < numberOfBands; ++i) {
                numBits[i] = bitsPerSample;
            }
            ComponentColorModelJAI colorModel = new ComponentColorModelJAI((ColorSpace)colorSpace, numBits, false, false, 1, dataType);
            int[] bankIndices = new int[numberOfBands];
            int[] bandOffsets = new int[numberOfBands];
            for (i = 0; i < numberOfBands; ++i) {
                bankIndices[i] = i;
                bandOffsets[i] = 0;
            }
            BandedSampleModel sampleModel = new BandedSampleModel(dataType, 1, 1, 1, bankIndices, bandOffsets);
            its = new ImageTypeSpecifier((ColorModel)colorModel, sampleModel);
        }
        return its;
    }

    private static ImageTypeSpecifier createFourBitColorMappedImageSpec(int sampleImageWidth, int sampleImageHeight, byte noDataValue) {
        int maxValue = (int)RasterCellType.TYPE_4BIT.getSampleValueRange().getMaximum();
        int mapSize = noDataValue > maxValue ? noDataValue : maxValue + 1;
        int[] cmap = new int[mapSize];
        ColorUtilities.expand((Color[])new Color[]{Color.BLACK, Color.WHITE}, (int[])cmap, (int)0, (int)maxValue);
        for (int i = maxValue; i < mapSize; ++i) {
            cmap[i] = ColorUtilities.getIntFromColor((int)0, (int)0, (int)0, (int)0);
        }
        int transparentPixel = noDataValue;
        IndexColorModel colorModel = new IndexColorModel(8, mapSize, cmap, 0, true, transparentPixel, 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createOneBitColorMappedImageSpec(int sampleImageWidth, int sampleImageHeight, byte noDataValue) {
        assert (noDataValue == 2);
        int FALSE = ColorUtilities.getIntFromColor((int)255, (int)255, (int)255, (int)255);
        int TRUE = ColorUtilities.getIntFromColor((int)0, (int)0, (int)0, (int)255);
        int NODATA = ColorUtilities.getIntFromColor((int)255, (int)255, (int)255, (int)0);
        int mapSize = 3;
        int[] cmap = new int[]{FALSE, TRUE, NODATA};
        byte transparentPixel = noDataValue;
        IndexColorModel colorModel = new IndexColorModel(8, 3, cmap, 0, false, (int)transparentPixel, 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createRGBAImageSpec(int sampleImageWidth, int sampleImageHeight, int dataType) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean hasAlpha = true;
        boolean isAlphaPremultiplied = false;
        int transparency = 3;
        int transferType = dataType;
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModelJAI colorModel = new ComponentColorModelJAI(colorSpace, nBits, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, sampleImageWidth, sampleImageHeight, 4);
        ImageTypeSpecifier its = new ImageTypeSpecifier((ColorModel)colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createRGBImageSpec(int sampleImageWidth, int sampleImageHeight, int dataType) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        int transparency = 1;
        int transferType = dataType;
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, sampleImageWidth, sampleImageHeight, 3);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createGrayscaleImageSpec(int sampleImageWidth, int sampleImageHeight, int dataType, int bitsPerPixel) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        int transparency = 1;
        int transferType = dataType;
        int[] nbits = new int[]{bitsPerPixel};
        ComponentColorModelJAI colorModel = new ComponentColorModelJAI(colorSpace, nbits, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier((ColorModel)colorModel, sampleModel);
        return its;
    }

    private static ImageTypeSpecifier createColorMappedImageSpec(IndexColorModel colorModel, int sampleImageWidth, int sampleImageHeight) {
        LOGGER.fine("Found single-band colormapped raster, using its index color model");
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(sampleImageWidth, sampleImageHeight);
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        return its;
    }

    public static GridEnvelope setMosaicLocations(RasterDatasetInfo rasterInfo, List<RasterQueryInfo> results) {
        MathTransform modelToRaster;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        RasterQueryInfo dimensionChoice = RasterUtils.findLowestResolution(results);
        Long rasterId = dimensionChoice.getRasterId();
        int pyramidLevel = dimensionChoice.getPyramidLevel();
        int rasterIndex = rasterInfo.getRasterIndex(rasterId);
        MathTransform rasterToModel = rasterInfo.getRasterToModel(rasterIndex, pyramidLevel);
        try {
            modelToRaster = rasterToModel.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        for (RasterQueryInfo rasterResultInfo : results) {
            GeneralEnvelope rasterResultEnvelope = rasterResultInfo.getResultEnvelope();
            GridEnvelope targetRasterGridRange = RasterUtils.getTargetGridRange(modelToRaster, (Envelope)rasterResultEnvelope);
            rasterResultInfo.setMosaicLocation(targetRasterGridRange);
            minx = Math.min(minx, targetRasterGridRange.getLow(0));
            miny = Math.min(miny, targetRasterGridRange.getLow(1));
            maxx = Math.max(maxx, targetRasterGridRange.getHigh(0));
            maxy = Math.max(maxy, targetRasterGridRange.getHigh(1));
        }
        GridEnvelope2D mosaicDimension = new GridEnvelope2D(minx, miny, 1 + (maxx - minx), 1 + (maxy - miny));
        return mosaicDimension;
    }

    public static RasterQueryInfo findLowestResolution(List<RasterQueryInfo> results) {
        double[] prev = new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
        RasterQueryInfo lowestResQuery = null;
        for (RasterQueryInfo query : results) {
            double[] curr = query.getResolution();
            if (!(curr[0] > prev[0])) continue;
            prev = curr;
            lowestResQuery = query;
        }
        return lowestResQuery;
    }

    public static List<RasterQueryInfo> findMatchingRasters(RasterDatasetInfo rasterInfo, GeneralEnvelope requestedEnvelope, GridEnvelope requestedDim, OverviewPolicy overviewPolicy) {
        int numRasters = rasterInfo.getNumRasters();
        ArrayList<RasterQueryInfo> matchingRasters = new ArrayList<RasterQueryInfo>(numRasters);
        for (int rasterN = 0; rasterN < numRasters; ++rasterN) {
            int optimalPyramidLevel = rasterInfo.getOptimalPyramidLevel(rasterN, overviewPolicy, requestedEnvelope, requestedDim);
            GeneralEnvelope gridEnvelope = rasterInfo.getGridEnvelope(rasterN, optimalPyramidLevel);
            boolean edgesInclusive = true;
            if (!requestedEnvelope.intersects((Envelope)gridEnvelope, true)) continue;
            RasterQueryInfo match = new RasterQueryInfo();
            match.setRequestedEnvelope(requestedEnvelope);
            match.setRequestedDim(requestedDim);
            match.setRasterId(rasterInfo.getRasterId(rasterN));
            match.setRasterIndex(rasterN);
            match.setPyramidLevel(optimalPyramidLevel);
            match.setResolution(rasterInfo.getResolution(rasterN, optimalPyramidLevel));
            matchingRasters.add(match);
        }
        return matchingRasters;
    }

    public static void fitRequestToRaster(GeneralEnvelope requestedEnvelope, RasterDatasetInfo rasterInfo, RasterQueryInfo query) {
        GeneralEnvelope resultEnvelope;
        GridEnvelope2D resultGridRange;
        int rasterIndex = query.getRasterIndex();
        int pyramidLevel = query.getPyramidLevel();
        MathTransform2D rasterToModel = (MathTransform2D)rasterInfo.getRasterToModel(rasterIndex, pyramidLevel);
        try {
            MathTransform2D modelToRaster = rasterToModel.inverse();
            GeneralEnvelope adjustedGRange = CRS.transform((MathTransform)modelToRaster, (Envelope)requestedEnvelope);
            int xmin = (int)Math.floor(adjustedGRange.getMinimum(0));
            int ymin = (int)Math.floor(adjustedGRange.getMinimum(1));
            int xmax = (int)Math.ceil(adjustedGRange.getMaximum(0));
            int ymax = (int)Math.ceil(adjustedGRange.getMaximum(1));
            GridEnvelope levelRange = rasterInfo.getGridRange(rasterIndex, pyramidLevel);
            xmin = Math.max(xmin, levelRange.getLow(0));
            ymin = Math.max(ymin, levelRange.getLow(1));
            xmax = Math.min(xmax, levelRange.getHigh(0) + 1);
            ymax = Math.min(ymax, levelRange.getHigh(1) + 1);
            int width = xmax - xmin;
            int height = ymax - ymin;
            resultGridRange = new GridEnvelope2D(xmin, ymin, width, height);
            Rectangle2D finalEnvelope = CRS.transform((MathTransform2D)rasterToModel, (Rectangle2D)((Rectangle2D)resultGridRange), (Rectangle2D)new Rectangle2D.Double());
            resultEnvelope = new GeneralEnvelope(finalEnvelope);
            CoordinateReferenceSystem crs = rasterInfo.getCoverageCrs();
            resultEnvelope.setCoordinateReferenceSystem(crs);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        GridEnvelope matchingTiles = RasterUtils.findMatchingTiles(rasterInfo, rasterIndex, pyramidLevel, (GridEnvelope)resultGridRange);
        GridEnvelope tiledImageGridRange = RasterUtils.getTiledImageGridRange(rasterInfo.getTileDimension(rasterIndex), matchingTiles);
        query.setResultEnvelope(resultEnvelope);
        query.setResultGridRange((GridEnvelope)resultGridRange);
        query.setMatchingTiles(matchingTiles);
        query.setTiledImageGridRange(tiledImageGridRange);
    }

    private static GridEnvelope getTiledImageGridRange(Dimension tileSize, GridEnvelope matchingTiles) {
        int tiledImageMinX = matchingTiles.getLow(0) * tileSize.width;
        int tiledImageMinY = matchingTiles.getLow(1) * tileSize.height;
        int tiledWidth = matchingTiles.getSpan(0) * tileSize.width;
        int tiledHeight = matchingTiles.getSpan(1) * tileSize.height;
        GridEnvelope2D tiledImageGridRange = new GridEnvelope2D(tiledImageMinX, tiledImageMinY, tiledWidth, tiledHeight);
        return tiledImageGridRange;
    }

    private static GridEnvelope findMatchingTiles(RasterDatasetInfo rasterInfo, int rasterIndex, int pyramidLevel, GridEnvelope resultGridRange) {
        Dimension tileSize = rasterInfo.getTileDimension(rasterIndex);
        int numTilesWide = rasterInfo.getNumTilesWide(rasterIndex, pyramidLevel);
        int numTilesHigh = rasterInfo.getNumTilesHigh(rasterIndex, pyramidLevel);
        GridEnvelope matchingTiles = RasterUtils.findMatchingTiles(tileSize, numTilesWide, numTilesHigh, resultGridRange);
        return matchingTiles;
    }

    public static IndexColorModel ensureNoDataPixelIsAvailable(IndexColorModel colorMap) {
        int newTransferType;
        int significantBits;
        int transparentPixel = colorMap.getTransparentPixel();
        if (transparentPixel > -1) {
            return colorMap;
        }
        int transferType = colorMap.getTransferType();
        int mapSize = colorMap.getMapSize();
        int maxSize = 65536;
        if (mapSize == 65536) {
            LOGGER.fine("There's no room for a new transparent pixel, returning the original colorMap as is");
            return colorMap;
        }
        int newMapSize = mapSize + 1;
        int[] argb = new int[newMapSize];
        colorMap.getRGBs(argb);
        argb[newMapSize - 1] = ColorUtilities.getIntFromColor((int)0, (int)0, (int)0, (int)0);
        if (0 == transferType && newMapSize <= 256) {
            significantBits = colorMap.getPixelSize();
            newTransferType = 0;
        } else if (0 == transferType && newMapSize == 257) {
            significantBits = 9;
            newTransferType = 1;
        } else {
            significantBits = 16;
            newTransferType = 1;
        }
        int transparentPixelIndex = newMapSize - 1;
        boolean hasalpha = true;
        boolean startIndex = false;
        IndexColorModel targetColorModel = new IndexColorModel(significantBits, newMapSize, argb, 0, true, transparentPixelIndex, newTransferType);
        return targetColorModel;
    }

    public static Number determineNoDataValue(IndexColorModel colorMap) {
        int noDataPixel = colorMap.getTransparentPixel();
        if (-1 == noDataPixel) {
            noDataPixel = ColorUtilities.getTransparentPixel((IndexColorModel)colorMap);
        }
        return noDataPixel;
    }

    public static Number determineNoDataValue(int numBands, double statsMin, double statsMax, RasterCellType nativeCellType) {
        boolean isUnsigned;
        double greater;
        double lower;
        if (nativeCellType == RasterCellType.TYPE_32BIT_REAL) {
            LOGGER.fine("no data value is Float.NaN");
            return Float.valueOf(Float.NaN);
        }
        if (nativeCellType == RasterCellType.TYPE_64BIT_REAL) {
            LOGGER.fine("no data value is Double.NaN");
            return Double.NaN;
        }
        if (nativeCellType == RasterCellType.TYPE_1BIT) {
            LOGGER.fine("1BIT images no-data value is set to 2, regardless of the raster statistics");
            return 2.0;
        }
        if (nativeCellType == RasterCellType.TYPE_4BIT) {
            LOGGER.fine("4BIT images no-data value is set to 16, regardless of the raster statistics");
            return 16.0;
        }
        if (!RasterUtils.isGeoPhysics(numBands, nativeCellType)) {
            LOGGER.fine("3 or 4 band, 8 bit unsigned image, assumed to be RGB or RGBA respectively and nodata value hardcoded to 255");
            return (Number)((Object)nativeCellType.getSampleValueRange().getMaxValue());
        }
        NumberRange<?> sampleValueRange = nativeCellType.getSampleValueRange();
        double minimumSample = sampleValueRange.getMinimum(true);
        double maximumSample = sampleValueRange.getMaximum(true);
        if (Double.isNaN(statsMin) || Double.isNaN(statsMax)) {
            lower = Math.ceil(minimumSample - 1.0);
            greater = Math.floor(maximumSample + 1.0);
        } else {
            lower = Math.ceil(statsMin - 1.0);
            greater = Math.floor(statsMax + 1.0);
        }
        boolean bl = isUnsigned = minimumSample == 0.0;
        Double nodata = sampleValueRange.contains((Number)lower) ? Double.valueOf(lower) : (sampleValueRange.contains((Number)greater) ? Double.valueOf(greater) : (isUnsigned ? Double.valueOf(greater) : Double.valueOf(lower)));
        return nodata;
    }

    public static boolean isGeoPhysics(int numBands, RasterCellType nativeCellType) {
        boolean geophysics = true;
        if (nativeCellType == RasterCellType.TYPE_8BIT_U && (numBands == 3 || numBands == 4)) {
            geophysics = false;
        }
        return geophysics;
    }

    public static RasterCellType determineTargetCellType(RasterCellType nativeCellType, List<Number> noDataValues) {
        if (RasterCellType.TYPE_32BIT_REAL == nativeCellType || RasterCellType.TYPE_64BIT_REAL == nativeCellType) {
            for (Number nodata : noDataValues) {
                if (Double.isNaN(nodata.doubleValue())) continue;
                throw new IllegalArgumentException("no data values for float and double cell types shall be NaN: " + nodata);
            }
            return nativeCellType;
        }
        double noDataMin = Double.POSITIVE_INFINITY;
        double noDataMax = Double.NEGATIVE_INFINITY;
        for (Number noData : noDataValues) {
            noDataMin = Math.min(noDataMin, noData.doubleValue());
            noDataMax = Math.max(noDataMax, noData.doubleValue());
        }
        NumberRange sampleValueRange = nativeCellType.getSampleValueRange().castTo(Double.class);
        RasterCellType targetCellType = sampleValueRange.contains((Number)noDataMin) && sampleValueRange.contains((Number)noDataMax) ? nativeCellType : RasterUtils.promote(nativeCellType);
        return targetCellType;
    }

    private static RasterCellType promote(RasterCellType nativeCellType) {
        switch (nativeCellType) {
            case TYPE_1BIT: 
            case TYPE_4BIT: {
                return RasterCellType.TYPE_8BIT_U;
            }
            case TYPE_8BIT_U: {
                return RasterCellType.TYPE_16BIT_U;
            }
            case TYPE_8BIT_S: {
                return RasterCellType.TYPE_16BIT_S;
            }
            case TYPE_16BIT_U: {
                return RasterCellType.TYPE_32BIT_U;
            }
            case TYPE_16BIT_S: {
                return RasterCellType.TYPE_32BIT_S;
            }
            case TYPE_32BIT_S: 
            case TYPE_32BIT_REAL: 
            case TYPE_32BIT_U: {
                return RasterCellType.TYPE_64BIT_REAL;
            }
        }
        throw new IllegalArgumentException("Can't promote a raster of type 64-bit-real, there's no higher pixel depth than that!");
    }
}

