/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.arcsde.gce.ArcSDERasterFormat;
import org.geotools.arcsde.gce.RasterDatasetInfo;
import org.geotools.arcsde.gce.RasterQueryInfo;
import org.geotools.arcsde.gce.RasterReaderFactory;
import org.geotools.arcsde.gce.RasterUtils;
import org.geotools.arcsde.gce.TiledRasterReader;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArcSDEGridCoverage2DReaderJAI
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private static final boolean DEBUG_TO_DISK = Boolean.getBoolean("org.geotools.arcsde.gce.debug");
    private final ArcSDERasterFormat parent;
    private final RasterDatasetInfo rasterInfo;
    private DefaultServiceInfo serviceInfo;
    private RasterReaderFactory rasterReaderFactory;

    public ArcSDEGridCoverage2DReaderJAI(ArcSDERasterFormat parent, RasterReaderFactory rasterReaderFactory, RasterDatasetInfo rasterInfo, Hints hints) throws IOException {
        int bitsPerSample = rasterInfo.getBand(0, 0).getCellType().getBitsPerSample();
        if (rasterInfo.getNumBands() > 1 && (bitsPerSample == 1 || bitsPerSample == 4)) {
            throw new IllegalArgumentException(bitsPerSample + "-bit rasters with more than one band are not supported");
        }
        this.parent = parent;
        this.rasterReaderFactory = rasterReaderFactory;
        this.rasterInfo = rasterInfo;
        this.hints = hints;
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        this.crs = rasterInfo.getCoverageCrs();
        this.originalEnvelope = rasterInfo.getOriginalEnvelope();
        GeneralGridEnvelope gridRange = rasterInfo.getOriginalGridRange();
        this.originalGridRange = new GridEnvelope2D(gridRange.toRectangle());
        this.coverageName = rasterInfo.getRasterTable();
        int numLevels = rasterInfo.getNumPyramidLevels(0);
        this.numOverviews = numLevels - 1;
        this.highestRes = AbstractGridCoverage2DReader.getResolution((GeneralEnvelope)this.originalEnvelope, (Rectangle2D)((Rectangle)this.originalGridRange), (CoordinateReferenceSystem)this.crs);
        if (this.numOverviews > 0) {
            this.overViewResolutions = new double[this.numOverviews][2];
            for (int pyramidLevel = 1; pyramidLevel <= this.numOverviews; ++pyramidLevel) {
                Rectangle levelGridRange = rasterInfo.getGridRange(0, pyramidLevel);
                GeneralEnvelope levelEnvelope = rasterInfo.getGridEnvelope(0, pyramidLevel);
                this.overViewResolutions[pyramidLevel - 1] = AbstractGridCoverage2DReader.getResolution((GeneralEnvelope)levelEnvelope, (Rectangle2D)levelGridRange, (CoordinateReferenceSystem)this.crs);
            }
        } else {
            this.overViewResolutions = null;
        }
    }

    public Format getFormat() {
        return this.parent;
    }

    public ServiceInfo getInfo() {
        if (this.serviceInfo == null) {
            this.serviceInfo = new DefaultServiceInfo();
            this.serviceInfo.setTitle(this.rasterInfo.getRasterTable());
            this.serviceInfo.setDescription(this.rasterInfo.toString());
            HashSet<String> keywords = new HashSet<String>();
            keywords.add("ArcSDE");
            this.serviceInfo.setKeywords(keywords);
        }
        return this.serviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        ReadParameters opParams = RasterUtils.parseReadParams(this.getOriginalEnvelope(), params);
        GeneralEnvelope requestedEnvelope = opParams.requestedEnvelope;
        Rectangle requestedDim = opParams.dim;
        OverviewPolicy overviewPolicy = opParams.overviewPolicy;
        List<RasterQueryInfo> queries = this.findMatchingRasters(requestedEnvelope, requestedDim, overviewPolicy);
        if (queries.isEmpty()) {
            return this.createFakeCoverage(requestedEnvelope, requestedDim);
        }
        GeneralEnvelope resultEnvelope = this.getResultEnvelope(queries);
        LoggingHelper log = new LoggingHelper();
        log.appendLoggingGeometries(LoggingHelper.REQ_ENV, requestedEnvelope);
        log.appendLoggingGeometries(LoggingHelper.RES_ENV, resultEnvelope);
        Rectangle mosaicGeometry = RasterUtils.setMosaicLocations(this.rasterInfo, resultEnvelope, queries);
        HashMap<Long, RasterQueryInfo> byRasterIdQueries = new HashMap<Long, RasterQueryInfo>();
        for (RasterQueryInfo queryInfo : queries) {
            byRasterIdQueries.put(queryInfo.getRasterId(), queryInfo);
        }
        TiledRasterReader rasterReader = this.rasterReaderFactory.create(this.rasterInfo);
        try {
            this.readAllTiledRasters(byRasterIdQueries, rasterReader, log);
        }
        finally {
            rasterReader.dispose();
        }
        log.log(LoggingHelper.REQ_ENV);
        log.log(LoggingHelper.RES_ENV);
        log.log(LoggingHelper.MOSAIC_ENV);
        log.log(LoggingHelper.MOSAIC_EXPECTED);
        RenderedImage coverageRaster = this.createMosaic(queries, log);
        assert (mosaicGeometry.getWidth() == (double)coverageRaster.getWidth());
        assert (mosaicGeometry.getHeight() == (double)coverageRaster.getHeight());
        GridSampleDimension[] bands = this.getSampleDimensions(coverageRaster);
        GridCoverage2D resultCoverage = this.coverageFactory.create((CharSequence)this.coverageName, coverageRaster, (Envelope)resultEnvelope, bands, null, null);
        return resultCoverage;
    }

    private GridSampleDimension[] getSampleDimensions(RenderedImage coverageRaster) throws IOException {
        GridSampleDimension[] bands = this.rasterInfo.getGridSampleDimensions();
        int imageBands = coverageRaster.getSampleModel().getNumBands();
        if (bands.length == 1 && imageBands > 1) {
            LOGGER.fine(this.coverageName + " was promoted from 1 to " + coverageRaster.getSampleModel().getNumBands() + " bands, returning an appropriate set of GridSampleDimension");
            ColorModel cm = coverageRaster.getColorModel();
            bands = new GridSampleDimension[imageBands];
            for (int i = 0; i < imageBands; ++i) {
                ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
                if (colorInterpretation == null) {
                    throw new IOException("Unrecognized sample dimension type");
                }
                bands[i] = new GridSampleDimension((CharSequence)colorInterpretation.name()).geophysics(true);
            }
        }
        return bands;
    }

    private void readAllTiledRasters(Map<Long, RasterQueryInfo> byRasterIdQueries, TiledRasterReader rasterReader, LoggingHelper log) throws IOException {
        Long currentRasterId;
        while ((currentRasterId = rasterReader.nextRaster()) != null) {
            RenderedImage rasterImage;
            if (!byRasterIdQueries.containsKey(currentRasterId)) continue;
            RasterQueryInfo queryInfo = byRasterIdQueries.get(currentRasterId);
            try {
                int pyramidLevel = queryInfo.getPyramidLevel();
                Rectangle matchingTiles = queryInfo.getMatchingTiles();
                rasterImage = rasterReader.read(pyramidLevel, matchingTiles);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Fetching data for " + queryInfo.toString(), e);
                throw e;
            }
            queryInfo.setResultImage(rasterImage);
            LOGGER.finer(queryInfo.toString());
            log.appendLoggingGeometries(LoggingHelper.MOSAIC_EXPECTED, queryInfo.getMosaicLocation());
            log.appendLoggingGeometries(LoggingHelper.MOSAIC_ENV, queryInfo.getResultEnvelope());
            Rectangle tiledImageSize = queryInfo.getTiledImageSize();
            int width = rasterImage.getWidth();
            int height = rasterImage.getHeight();
            if (tiledImageSize.width != width || tiledImageSize.height != height) {
                throw new IllegalStateException("Read image is not of the expected size. Image=" + width + "x" + height + ", expected: " + tiledImageSize.width + "x" + tiledImageSize.height);
            }
            if (tiledImageSize.x == rasterImage.getMinX() && tiledImageSize.y == rasterImage.getMinY()) continue;
            throw new IllegalStateException("Read image is not at the expected location " + tiledImageSize.x + "," + tiledImageSize.y + ": " + rasterImage.getMinX() + "," + rasterImage.getMinY());
        }
    }

    private GridCoverage2D createFakeCoverage(GeneralEnvelope requestedEnvelope, Rectangle requestedDim) {
        ImageTypeSpecifier its = this.rasterInfo.getRenderedImageSpec(0);
        SampleModel sampleModel = its.getSampleModel(requestedDim.width, requestedDim.height);
        ColorModel colorModel = its.getColorModel();
        WritableRaster raster = Raster.createWritableRaster(sampleModel, null);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, (Envelope)requestedEnvelope);
    }

    private List<RasterQueryInfo> findMatchingRasters(GeneralEnvelope requestedEnvelope, Rectangle requestedDim, OverviewPolicy overviewPolicy) {
        List<RasterQueryInfo> matchingQueries = RasterUtils.findMatchingRasters(this.rasterInfo, requestedEnvelope, requestedDim, overviewPolicy);
        if (matchingQueries.isEmpty()) {
            return matchingQueries;
        }
        for (RasterQueryInfo match : matchingQueries) {
            RasterUtils.fitRequestToRaster(requestedEnvelope, this.rasterInfo, match);
        }
        return matchingQueries;
    }

    private GeneralEnvelope getResultEnvelope(List<RasterQueryInfo> queryInfos) {
        GeneralEnvelope finalEnvelope = null;
        for (RasterQueryInfo rasterQueryInfo : queryInfos) {
            if (finalEnvelope == null) {
                finalEnvelope = new GeneralEnvelope((Envelope)rasterQueryInfo.getResultEnvelope());
                continue;
            }
            finalEnvelope.add((Envelope)rasterQueryInfo.getResultEnvelope());
        }
        if (finalEnvelope == null) {
            throw new IllegalStateException("Restult envelope is null, this shouldn't happen!! we checked the request overlaps the coverage envelope before!");
        }
        return finalEnvelope;
    }

    private RenderedImage createMosaic(List<RasterQueryInfo> queries, LoggingHelper log) throws IOException {
        RenderedImage mosaic;
        boolean expandThenContractCM;
        ArrayList<RenderedImage> transformed = new ArrayList<RenderedImage>(queries.size());
        boolean bl = expandThenContractCM = queries.size() > 1 && this.rasterInfo.isColorMapped();
        if (expandThenContractCM) {
            LOGGER.info("Creating mosaic out of " + queries.size() + " colormapped rasters. The mosaic tiles will be expanded to " + "\nRGB space and the resulting mosaic reduced to a new IndexColorModel");
        }
        for (RasterQueryInfo query : queries) {
            RenderedImage image = query.getResultImage();
            log.log(image, query.getRasterId(), "01_original");
            image = this.cropToRequiredDimension(image, query.getResultDimensionInsideTiledImage());
            log.log(image, query.getRasterId(), "02_crop");
            Rectangle mosaicLocation = query.getMosaicLocation();
            Float scaleX = Float.valueOf((float)(mosaicLocation.getWidth() / (double)image.getWidth()));
            Float scaleY = Float.valueOf((float)(mosaicLocation.getHeight() / (double)image.getHeight()));
            Object translateX = null;
            Object translateY = null;
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(scaleX);
            pb.add(scaleY);
            pb.add(translateX);
            pb.add(translateY);
            pb.add(new InterpolationNearest());
            image = JAI.create((String)"scale", (ParameterBlock)pb);
            log.log(image, query.getRasterId(), "03_scale");
            int width = image.getWidth();
            int height = image.getHeight();
            assert (mosaicLocation.width == width);
            assert (mosaicLocation.height == height);
            pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(Float.valueOf(mosaicLocation.x - image.getMinX()));
            pb.add(Float.valueOf(mosaicLocation.y - image.getMinY()));
            pb.add(null);
            image = JAI.create((String)"translate", (ParameterBlock)pb);
            log.log(image, query.getRasterId(), "04_translate");
            assert (image.getMinX() == mosaicLocation.x) : image.getMinX() + " != " + mosaicLocation.x;
            assert (image.getMinY() == mosaicLocation.y) : image.getMinY() + " != " + mosaicLocation.y;
            assert (image.getWidth() == mosaicLocation.width) : image.getWidth() + " != " + mosaicLocation.width;
            assert (image.getHeight() == mosaicLocation.height) : image.getHeight() + " != " + mosaicLocation.height;
            if (expandThenContractCM) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Creating color expanded version of tile for raster #" + query.getRasterId());
                }
                image = FormatDescriptor.create((RenderedImage)image, (Integer)0, null);
                log.log(image, query.getRasterId(), "04_1_colorExpanded");
            }
            transformed.add(image);
        }
        if (queries.size() == 1) {
            mosaic = (RenderedImage)transformed.get(0);
        } else {
            ParameterBlock mosaicParams = new ParameterBlock();
            for (RenderedImage img : transformed) {
                mosaicParams.addSource(img);
                log.appendLoggingGeometries(LoggingHelper.MOSAIC_RESULT, img);
            }
            log.log(LoggingHelper.MOSAIC_RESULT);
            mosaicParams.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            mosaicParams.add(null);
            mosaicParams.add(null);
            mosaicParams.add(null);
            mosaicParams.add(null);
            LOGGER.fine("Creating mosaic out of " + queries.size() + " raster tiles");
            mosaic = JAI.create((String)"Mosaic", (ParameterBlock)mosaicParams);
            log.log(mosaic, 0L, "05_mosaic_result");
        }
        return mosaic;
    }

    private RenderedImage cropToRequiredDimension(RenderedImage fullTilesRaster, Rectangle cropTo) {
        int height;
        int width;
        int minY;
        int minX = fullTilesRaster.getMinX();
        Rectangle origDim = new Rectangle(minX, minY = fullTilesRaster.getMinY(), width = fullTilesRaster.getWidth(), height = fullTilesRaster.getHeight());
        if (!origDim.contains(cropTo)) {
            throw new IllegalArgumentException("Original image (" + origDim + ") does not contain desired dimension (" + cropTo + ")");
        }
        if (origDim.equals(cropTo)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No need to crop image, full tiled dimension and target one do match: original: " + width + "x" + height + ", target: " + cropTo.width + "x" + cropTo.height);
            }
            return fullTilesRaster;
        }
        ParameterBlock cropParams = new ParameterBlock();
        cropParams.addSource(fullTilesRaster);
        cropParams.add(Float.valueOf(cropTo.x));
        cropParams.add(Float.valueOf(cropTo.y));
        cropParams.add(Float.valueOf(cropTo.width));
        cropParams.add(Float.valueOf(cropTo.height));
        RenderingHints hints = null;
        RenderedOp image = JAI.create((String)"Crop", (ParameterBlock)cropParams, hints);
        assert (cropTo.x == image.getMinX());
        assert (cropTo.y == image.getMinY());
        assert (cropTo.width == image.getWidth());
        assert (cropTo.height == image.getHeight());
        return image;
    }

    private static class LoggingHelper {
        private static final File debugDir = new File(System.getProperty("user.home") + File.separator + "arcsde_test");
        public Level GEOM_LEVEL = Level.FINER;
        public static String REQ_ENV;
        public static String RES_ENV;
        public static String MOSAIC_ENV;
        public static String MOSAIC_EXPECTED;
        public static String MOSAIC_RESULT;
        private Map<String, StringBuilder> geoms = null;

        LoggingHelper() {
        }

        private StringBuilder getGeom(String geomName) {
            StringBuilder sb;
            if (this.geoms == null) {
                this.geoms = new HashMap<String, StringBuilder>();
            }
            if ((sb = this.geoms.get(geomName)) == null) {
                sb = new StringBuilder("MULTIPOLYGON(\n");
                this.geoms.put(geomName, sb);
            }
            return sb;
        }

        public void appendLoggingGeometries(String geomName, RenderedImage img) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                this.appendLoggingGeometries(geomName, new Rectangle(img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight()));
            }
        }

        public void appendLoggingGeometries(String geomName, Rectangle env) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                this.appendLoggingGeometries(geomName, new GeneralEnvelope((Rectangle2D)env));
            }
        }

        public void appendLoggingGeometries(String geomName, GeneralEnvelope env) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                StringBuilder sb = this.getGeom(geomName);
                sb.append("  ((" + env.getMinimum(0) + " " + env.getMinimum(1) + ", " + env.getMaximum(0) + " " + env.getMinimum(1) + ", " + env.getMaximum(0) + " " + env.getMaximum(1) + ", " + env.getMinimum(0) + " " + env.getMaximum(1) + ", " + env.getMinimum(0) + " " + env.getMinimum(1) + ")),");
            }
        }

        public void log(String geomName) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                StringBuilder sb = this.getGeom(geomName);
                sb.setLength(sb.length() - 1);
                sb.append("\n)");
                LOGGER.log(this.GEOM_LEVEL, geomName + ":\n" + sb.toString());
            }
        }

        public void log(RenderedImage image, Long rasterId, String fileName) {
            if (DEBUG_TO_DISK) {
                LOGGER.warning("BEWARE THE DEBUG FLAG IS TURNED ON! IF IN PRODUCTION THIS IS A SEVERE MISTAKE!!!");
                try {
                    ImageIO.write(image, "TIFF", new File(debugDir, rasterId + fileName + ".tiff"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            if (DEBUG_TO_DISK) {
                debugDir.mkdir();
            }
            REQ_ENV = "Requested envelope";
            RES_ENV = "Resulting envelope";
            MOSAIC_ENV = "Resulting mosaiced envelopes";
            MOSAIC_EXPECTED = "Expected mosaic layout (in pixels)";
            MOSAIC_RESULT = "Resulting image mosaic layout (in pixels)";
        }
    }

    static class ReadParameters {
        GeneralEnvelope requestedEnvelope;
        Rectangle dim;
        OverviewPolicy overviewPolicy;

        ReadParameters() {
        }
    }
}

