/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.gce.BitmaskToNoDataConverter;
import org.geotools.arcsde.gce.RasterCellType;
import org.geotools.arcsde.gce.TileReader;
import org.geotools.util.logging.Logging;

final class PromotingTileReader
implements TileReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private final TileReader nativeReader;
    private final RasterCellType targetType;
    private final SampleDepthPromoter promoter;
    private final BitmaskToNoDataConverter noData;
    private final byte[] nativeTileData;

    public PromotingTileReader(TileReader nativeTileReader, RasterCellType sourceType, RasterCellType targetType, BitmaskToNoDataConverter noData) {
        this.nativeReader = nativeTileReader;
        this.targetType = targetType;
        this.noData = noData;
        this.nativeTileData = new byte[nativeTileReader.getBytesPerTile()];
        this.promoter = SampleDepthPromoter.createFor(sourceType, targetType);
        LOGGER.fine("Using sample depth promoting tile reader, from " + (Object)((Object)sourceType) + " to " + (Object)((Object)targetType));
    }

    public int getBitsPerSample() {
        return this.targetType.getBitsPerSample();
    }

    public int getBytesPerTile() {
        double pixelsPerTile = this.getPixelsPerTile();
        double bitsPerSample = this.getBitsPerSample();
        int bytesPerTile = (int)Math.floor(pixelsPerTile * bitsPerSample / 8.0);
        return bytesPerTile;
    }

    public int getNumberOfBands() {
        return this.nativeReader.getNumberOfBands();
    }

    public int getPixelsPerTile() {
        return this.nativeReader.getPixelsPerTile();
    }

    public int getTileHeight() {
        return this.nativeReader.getTileHeight();
    }

    public int getTileWidth() {
        return this.nativeReader.getTileWidth();
    }

    public int getTilesHigh() {
        return this.nativeReader.getTilesHigh();
    }

    public int getTilesWide() {
        return this.nativeReader.getTilesWide();
    }

    public boolean hasNext() throws IOException {
        return this.nativeReader.hasNext();
    }

    public TileReader.TileInfo next(byte[] tileData) throws IOException {
        TileReader.TileInfo tileInfo = this.nativeReader.next(this.nativeTileData);
        byte[] bitmaskData = tileInfo.getBitmaskData();
        boolean hasNoDataPixels = bitmaskData.length > 0;
        Long bandId = tileInfo.getBandId();
        int numPixelsRead = tileInfo.getNumPixelsRead();
        if (numPixelsRead == 0) {
            this.noData.setAll(bandId, tileData);
        } else {
            int numSamples = this.getPixelsPerTile();
            assert (numPixelsRead == numSamples);
            for (int sampleN = 0; sampleN < numSamples; ++sampleN) {
                if (hasNoDataPixels && this.noData.isNoData(sampleN, bitmaskData)) {
                    this.noData.setNoData(bandId, sampleN, tileData);
                    continue;
                }
                this.promoter.promote(sampleN, this.nativeTileData, tileData);
            }
        }
        return tileInfo;
    }

    private static class ShortToInt
    extends SampleDepthPromoter {
        private ShortToInt() {
        }

        public void promote(int sampleN, byte[] nativeTileData, byte[] tileData) {
            int pixArrayOffset = 4 * sampleN;
            tileData[pixArrayOffset] = 0;
            tileData[pixArrayOffset + 1] = 0;
            tileData[pixArrayOffset + 1] = (byte)(nativeTileData[sampleN] >>> 8 & 0xFF);
            tileData[pixArrayOffset + 1] = (byte)(nativeTileData[sampleN] >>> 0 & 0xFF);
        }
    }

    private static class OneBitToUchar
    extends SampleDepthPromoter {
        private OneBitToUchar() {
        }

        public void promote(int sampleN, byte[] nativeTileData, byte[] tileData) {
            byte ucharvalue;
            int pixArrayOffset = sampleN / 8;
            int bit = sampleN % 8;
            byte _byte = nativeTileData[pixArrayOffset];
            tileData[sampleN] = ucharvalue = (byte)(_byte >> 7 - bit & 1);
        }
    }

    private static class UcharToUshort
    extends SampleDepthPromoter {
        private UcharToUshort() {
        }

        public void promote(int sampleN, byte[] nativeTileData, byte[] tileData) {
            int pixArrayOffset = 2 * sampleN;
            tileData[pixArrayOffset] = 0;
            tileData[pixArrayOffset + 1] = (byte)(nativeTileData[sampleN] >>> 0 & 0xFF);
        }
    }

    private static abstract class SampleDepthPromoter {
        private SampleDepthPromoter() {
        }

        public abstract void promote(int var1, byte[] var2, byte[] var3);

        public static SampleDepthPromoter createFor(RasterCellType source, RasterCellType target) {
            if (source == RasterCellType.TYPE_1BIT && target == RasterCellType.TYPE_8BIT_U) {
                return new OneBitToUchar();
            }
            if (source == RasterCellType.TYPE_8BIT_U && target == RasterCellType.TYPE_16BIT_U) {
                return new UcharToUshort();
            }
            if (source == RasterCellType.TYPE_16BIT_S && target == RasterCellType.TYPE_32BIT_S) {
                return new ShortToInt();
            }
            UnsupportedOperationException exception = new UnsupportedOperationException("Promoting from " + (Object)((Object)source) + " to " + (Object)((Object)target) + " not yet implemented");
            LOGGER.log(Level.WARNING, "Can't promote", exception);
            throw exception;
        }
    }
}

