/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class PyramidLevelInfo {
    private int pyramidLevel;
    private int xTiles;
    private int yTiles;
    Point2D extentOffset;
    Point imageOffset;
    private double xRes;
    private double yRes;
    private ReferencedEnvelope envelope;
    public Dimension size;

    PyramidLevelInfo(int level, ReferencedEnvelope extent, Point imgOffset, Point2D extOffset, int numTilesWide, int numTilesHigh, Dimension levelSize) {
        this.pyramidLevel = level;
        this.xRes = extent.getWidth() / (double)levelSize.width;
        this.yRes = extent.getHeight() / (double)levelSize.height;
        this.envelope = extent;
        this.imageOffset = imgOffset;
        this.extentOffset = extOffset;
        this.xTiles = numTilesWide;
        this.yTiles = numTilesHigh;
        this.size = levelSize;
    }

    public int getLevel() {
        return this.pyramidLevel;
    }

    public double getXRes() {
        return this.xRes;
    }

    public double getYRes() {
        return this.yRes;
    }

    public int getXOffset() {
        return this.imageOffset.x;
    }

    public int getYOffset() {
        return this.imageOffset.y;
    }

    public int getNumTilesWide() {
        return this.xTiles;
    }

    public int getNumTilesHigh() {
        return this.yTiles;
    }

    public ReferencedEnvelope getImageEnvelope() {
        double deltaX = this.extentOffset.getX();
        double deltaY = this.extentOffset.getY();
        double minx = this.envelope.getMinX() - deltaX;
        double miny = this.envelope.getMinY() - deltaY;
        double maxx = minx + this.envelope.getWidth();
        double maxy = miny + this.envelope.getHeight();
        CoordinateReferenceSystem crs = this.envelope.getCoordinateReferenceSystem();
        ReferencedEnvelope imageExtent = new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
        return imageExtent;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Rectangle getImageRange() {
        int offsetX = this.getXOffset();
        int offsetY = this.getYOffset();
        Rectangle levelRange = new Rectangle(offsetX, offsetY, this.size.width, this.size.height);
        return levelRange;
    }

    public String toString() {
        return "[level: " + this.pyramidLevel + " size: " + this.size.width + "x" + this.size.height + "  xRes: " + this.xRes + "  yRes: " + this.yRes + "  xOffset: " + this.getXOffset() + "  yOffset: " + this.getYOffset() + "  extent: " + this.envelope.getMinX() + "," + this.envelope.getMinY() + " " + this.envelope.getMaxX() + "," + this.envelope.getMaxY() + "  tilesWide: " + this.xTiles + "  tilesHigh: " + this.yTiles + "]";
    }
}

