/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SeRow;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.geotools.arcsde.gce.BitmaskToNoDataConverter;
import org.geotools.arcsde.gce.NativeTileReader;
import org.geotools.arcsde.gce.PromotingTileReader;
import org.geotools.arcsde.gce.RasterCellType;
import org.geotools.arcsde.gce.RasterDatasetInfo;
import org.geotools.arcsde.gce.TileReader;

public class TileReaderFactory {
    public static TileReader getInstance(SeRow row, RasterDatasetInfo rasterInfo, int rasterIndex, Rectangle requestedTiles, Dimension tileSize) {
        TileReader tileReader;
        RasterCellType nativeType = rasterInfo.getNativeCellType();
        RasterCellType targetType = rasterInfo.getTargetCellType(rasterIndex);
        int numberOfBands = rasterInfo.getNumBands();
        BitmaskToNoDataConverter noData = BitmaskToNoDataConverter.getInstance(rasterInfo, rasterIndex);
        int nativeBitsPerPixel = nativeType.getBitsPerSample();
        if (targetType == nativeType) {
            NativeTileReader nativeTileReader;
            tileReader = nativeTileReader = new NativeTileReader(row, nativeBitsPerPixel, numberOfBands, requestedTiles, tileSize, noData);
        } else {
            NativeTileReader nativeTileReader = new NativeTileReader(row, nativeBitsPerPixel, numberOfBands, requestedTiles, tileSize, BitmaskToNoDataConverter.NO_ACTION_CONVERTER);
            PromotingTileReader promotingTileReader = new PromotingTileReader(nativeTileReader, nativeType, targetType, noData);
            tileReader = promotingTileReader;
        }
        return tileReader;
    }
}

