/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.geotools.arcsde.data.view.ExpressionQualifier;
import org.geotools.arcsde.data.view.SubSelectQualifier;
import org.geotools.arcsde.session.ISession;

class ItemsListQualifier
implements ItemsListVisitor {
    ItemsList _qualifiedList;
    private ISession session;
    private Map tableAliases;

    public ItemsListQualifier(ISession session, Map tableAliases) {
        this.session = session;
        this.tableAliases = tableAliases;
    }

    public static ItemsList qualify(ISession session, Map tableAliases, ItemsList items) {
        if (items == null) {
            return null;
        }
        ItemsListQualifier q = new ItemsListQualifier(session, tableAliases);
        items.accept((ItemsListVisitor)q);
        return q._qualifiedList;
    }

    public void visit(SubSelect subSelect) {
        SubSelect qualified = SubSelectQualifier.qualify(this.session, subSelect);
        this._qualifiedList = qualified;
    }

    public void visit(ExpressionList expressionList) {
        List expressions = expressionList.getExpressions();
        ArrayList<Expression> qualifiedList = new ArrayList<Expression>(expressions.size());
        for (Expression exp : expressions) {
            Expression qExp = ExpressionQualifier.qualify(this.session, this.tableAliases, exp);
            qualifiedList.add(qExp);
        }
        ExpressionList qExpList = new ExpressionList();
        qExpList.setExpressions(qualifiedList);
        this._qualifiedList = qExpList;
    }
}

