/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.io;

public final class TileInfo {
    private long bandId;
    private byte[] bitmaskData;
    private int numPixelsRead;
    private int columnIndex;
    private int rowIndex;
    private byte[] tileDataBytes;
    private short[] tileDataShorts;
    private int[] tileDataInts;
    private float[] tileDataFloats;
    private double[] tileDataDoubles;
    private final int numPixels;
    private Number noData;

    public TileInfo(int pixelsPerTile) {
        this.numPixels = pixelsPerTile;
    }

    public Long getBandId() {
        return this.bandId;
    }

    public byte[] getBitmaskData() {
        return this.bitmaskData;
    }

    public int getNumPixels() {
        return this.numPixels;
    }

    public int getNumPixelsRead() {
        return this.numPixelsRead;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setTileData(byte[] pixelData) {
        this.tileDataBytes = pixelData;
    }

    public void setTileData(short[] pixelData) {
        this.tileDataShorts = pixelData;
    }

    public void setTileData(int[] pixelData) {
        this.tileDataInts = pixelData;
    }

    public void setTileData(float[] pixelData) {
        this.tileDataFloats = pixelData;
    }

    public void setTileData(double[] pixelData) {
        this.tileDataDoubles = pixelData;
    }

    public byte[] getTileDataAsBytes() {
        if (this.tileDataBytes == null) {
            this.tileDataBytes = new byte[this.numPixels];
        }
        return this.tileDataBytes;
    }

    public short[] getTileDataAsUnsignedShorts() {
        if (this.tileDataShorts == null) {
            this.tileDataShorts = new short[this.numPixels];
        }
        return this.tileDataShorts;
    }

    public short[] getTileDataAsShorts() {
        if (this.tileDataShorts == null) {
            this.tileDataShorts = new short[this.numPixels];
        }
        return this.tileDataShorts;
    }

    public int[] getTileDataAsIntegers() {
        if (this.tileDataInts == null) {
            this.tileDataInts = new int[this.numPixels];
        }
        return this.tileDataInts;
    }

    public float[] getTileDataAsFloats() {
        if (this.tileDataFloats == null) {
            this.tileDataFloats = new float[this.numPixels];
        }
        return this.tileDataFloats;
    }

    public double[] getTileDataAsDoubles() {
        if (this.tileDataDoubles == null) {
            this.tileDataDoubles = new double[this.numPixels];
        }
        return this.tileDataDoubles;
    }

    public void setBandId(long bandId) {
        this.bandId = bandId;
    }

    public void setColumnIndex(int colIndex) {
        this.columnIndex = colIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setNumPixelsRead(int numPixelsRead) {
        this.numPixelsRead = numPixelsRead;
    }

    public void setBitmaskData(byte[] bitMaskData) {
        this.bitmaskData = bitMaskData;
    }

    public void setNoDataValue(Number noData) {
        this.noData = noData;
    }

    public Number getNoDataValue() {
        return this.noData;
    }

    public boolean hasNoDataPixels() {
        return this.bitmaskData.length > 0;
    }
}

