/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import javax.swing.Icon;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ExternalMark;
import org.geotools.styling.StyleFactory;
import org.opengis.metadata.citation.OnLineResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalMarkBuilder<P>
implements Builder<ExternalMark> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    boolean unset = true;
    private Icon inline;
    private String format;
    private int index;
    private OnLineResource resource;

    public ExternalMarkBuilder() {
        this.parent = null;
        this.reset();
    }

    public ExternalMarkBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public ExternalMark build() {
        if (this.unset) {
            return null;
        }
        if (this.inline != null) {
            return this.sf.externalMark(this.inline);
        }
        return this.sf.externalMark(this.resource, this.format, this.index);
    }

    public P end() {
        return this.parent;
    }

    @Override
    public ExternalMarkBuilder<P> reset() {
        this.unset = false;
        return this;
    }

    @Override
    public ExternalMarkBuilder<P> reset(org.opengis.style.ExternalMark mark) {
        if (mark == null) {
            return this.reset();
        }
        this.format = mark.getFormat();
        this.index = mark.getMarkIndex();
        this.inline = mark.getInlineContent();
        this.resource = mark.getOnlineResource();
        this.unset = false;
        return this;
    }

    @Override
    public ExternalMarkBuilder<P> reset(ExternalMark mark) {
        if (mark == null) {
            return this.reset();
        }
        this.format = mark.getFormat();
        this.index = mark.getMarkIndex();
        this.inline = mark.getInlineContent();
        this.resource = mark.getOnlineResource();
        this.unset = false;
        return this;
    }

    @Override
    public ExternalMarkBuilder<P> unset() {
        this.unset = true;
        return this;
    }

    public boolean isUnset() {
        return this.unset;
    }
}

