/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.builder.LineSymbolizerBuilder;
import org.geotools.styling.builder.PolygonSymbolizerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageOutlineBuilder<P>
implements Builder<ImageOutline> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    private Builder<Symbolizer> symbolizer;

    public ImageOutlineBuilder() {
        this.parent = null;
        this.reset();
    }

    public ImageOutlineBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public ImageOutline build() {
        if (this.symbolizer == null) {
            return null;
        }
        ImageOutline outline = this.sf.createImageOutline(this.symbolizer.build());
        return outline;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public ImageOutlineBuilder<P> reset() {
        this.symbolizer = new LineSymbolizerBuilder<ImageOutlineBuilder>(this);
        return this;
    }

    @Override
    public ImageOutlineBuilder<P> reset(ImageOutline outline) {
        if (outline == null) {
            return this.reset();
        }
        this.symbolizer = null;
        if (outline.getSymbolizer() instanceof LineSymbolizer) {
            LineSymbolizer lineSymbolizer = (LineSymbolizer)outline.getSymbolizer();
            this.symbolizer = new LineSymbolizerBuilder<ImageOutlineBuilder>(this).reset(lineSymbolizer);
        }
        if (outline.getSymbolizer() instanceof PolygonSymbolizer) {
            PolygonSymbolizer polySymbolizer = (PolygonSymbolizer)outline.getSymbolizer();
            this.symbolizer = new PolygonSymbolizerBuilder<ImageOutlineBuilder>(this).reset(polySymbolizer);
        }
        return this;
    }

    @Override
    public ImageOutlineBuilder<P> unset() {
        this.symbolizer = null;
        return this;
    }
}

