/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdBuilder<P>
implements Builder<Id> {
    protected Filter filter;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory2(null);
    protected P parent;
    protected boolean unset = false;
    private List<Identifier> ids = new ArrayList<Identifier>();

    public IdBuilder() {
        this.reset();
    }

    public IdBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public Id build() {
        if (this.unset) {
            return null;
        }
        return this.ff.id(new HashSet<Identifier>(this.ids));
    }

    public IdBuilder<P> fid(String fid) {
        this.ids.add((Identifier)this.ff.featureId(fid));
        return this;
    }

    public IdBuilder<P> featureId(String fid) {
        this.ids.add((Identifier)this.ff.featureId(fid));
        return this;
    }

    public IdBuilder<P> fid(List<String> fids) {
        for (String fid : fids) {
            this.ids.add((Identifier)this.ff.featureId(fid));
        }
        return this;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public IdBuilder<P> reset() {
        this.filter = Filter.EXCLUDE;
        this.unset = false;
        return this;
    }

    @Override
    public IdBuilder<P> reset(Id filter) {
        if (filter == null) {
            return this.unset();
        }
        this.ids.clear();
        this.ids.addAll(filter.getIdentifiers());
        this.unset = false;
        return this;
    }

    @Override
    public IdBuilder<P> unset() {
        this.unset = true;
        this.ids.clear();
        return this;
    }
}

