/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.IdBuilder;
import org.geotools.styling.Description;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.DescriptionBuilder;
import org.geotools.styling.builder.RuleBuilder;
import org.opengis.feature.type.Name;
import org.opengis.filter.Id;
import org.opengis.style.SemanticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureTypeStyleBuilder<P>
implements Builder<FeatureTypeStyle> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    String name;
    List<RuleBuilder<FeatureTypeStyleBuilder<P>>> rules = new ArrayList<RuleBuilder<FeatureTypeStyleBuilder<P>>>();
    DescriptionBuilder<FeatureTypeStyleBuilder<P>> description = new DescriptionBuilder();
    LinkedHashSet<Name> featureTypeNames = new LinkedHashSet();
    private IdBuilder<FeatureTypeStyleBuilder<P>> definedFor = new IdBuilder<FeatureTypeStyleBuilder>(this);
    private Set<SemanticType> types = new LinkedHashSet<SemanticType>();
    private boolean unset;

    public FeatureTypeStyleBuilder() {
        this(null);
    }

    public FeatureTypeStyleBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public RuleBuilder<FeatureTypeStyleBuilder<P>> rule() {
        RuleBuilder<FeatureTypeStyleBuilder<P>> ruleBuilder = new RuleBuilder<FeatureTypeStyleBuilder<P>>(this);
        this.rules.add(ruleBuilder);
        return ruleBuilder;
    }

    public FeatureTypeStyleBuilder<P> name(String name) {
        this.name = name;
        return this;
    }

    public FeatureTypeStyleBuilder<P> title(String title) {
        this.description.title(title);
        return this;
    }

    public DescriptionBuilder<FeatureTypeStyleBuilder<P>> description() {
        return this.description;
    }

    public FeatureTypeStyleBuilder<P> featureTypeName(String featureTypeName) {
        this.featureTypeNames.add((Name)new NameImpl(featureTypeName));
        return this;
    }

    public String name() {
        return this.name;
    }

    public List<RuleBuilder<FeatureTypeStyleBuilder<P>>> rules() {
        this.unset = false;
        return this.rules;
    }

    public FeatureTypeStyleBuilder<P> rules(List<Rule> rules) {
        this.unset = false;
        for (Rule rule : rules) {
            this.rules.add(new RuleBuilder<FeatureTypeStyleBuilder>(this).reset(rule));
        }
        return this;
    }

    public FeatureTypeStyleBuilder<P> description(Description description) {
        this.description.reset(description);
        this.unset = false;
        return this;
    }

    public LinkedHashSet<Name> featureTypeNames() {
        return this.featureTypeNames;
    }

    public void setFeatureTypeNames(List<Name> featureTypeNames) {
        this.featureTypeNames.addAll(featureTypeNames);
    }

    public IdBuilder<FeatureTypeStyleBuilder<P>> definedFor() {
        return this.definedFor;
    }

    public void definedFor(Id fids) {
        this.definedFor.reset(fids);
    }

    public Set<SemanticType> types() {
        return this.types;
    }

    public FeatureTypeStyleBuilder<P> featureTypeName(Name featureTypeName) {
        this.featureTypeNames.add(featureTypeName);
        this.unset = false;
        return this;
    }

    @Override
    public FeatureTypeStyle build() {
        if (this.unset) {
            return null;
        }
        ArrayList<Rule> list = new ArrayList<Rule>();
        for (RuleBuilder<FeatureTypeStyleBuilder<P>> ruleBuilder : this.rules) {
            list.add(ruleBuilder.build());
        }
        FeatureTypeStyle fts = this.sf.featureTypeStyle(this.name, (org.opengis.style.Description)this.description.build(), this.definedFor.build(), this.featureTypeNames, this.types, list);
        if (this.parent == null) {
            this.reset();
        }
        return fts;
    }

    @Override
    public FeatureTypeStyleBuilder<P> reset() {
        this.rules.clear();
        this.name = null;
        this.description.reset();
        this.definedFor.reset();
        this.featureTypeNames.clear();
        this.rules.clear();
        this.unset = false;
        return this;
    }

    @Override
    public Builder<FeatureTypeStyle> reset(FeatureTypeStyle fts) {
        if (fts == null) {
            return this.unset();
        }
        this.name = fts.getName();
        this.description.reset(fts.getDescription());
        this.definedFor.reset(fts.getFeatureInstanceIDs());
        this.featureTypeNames.clear();
        if (fts.featureTypeNames() != null) {
            this.featureTypeNames.addAll(fts.featureTypeNames());
        }
        this.rules.clear();
        if (fts.rules() != null) {
            for (Rule rule : fts.rules()) {
                this.rules.add(new RuleBuilder<FeatureTypeStyleBuilder>(this).reset(rule));
            }
        }
        this.unset = false;
        return this;
    }

    @Override
    public Builder<FeatureTypeStyle> unset() {
        this.unset = true;
        return this;
    }
}

