/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.caching.EvictableTree;
import org.geotools.caching.EvictionPolicy;
import org.geotools.caching.spatialindex.NodeIdentifier;

public class LRUEvictionPolicy
implements EvictionPolicy {
    private Map<NodeIdentifier, Object> queue = Collections.synchronizedMap(new LinkedHashMap(100, 0.75f, true));
    private EvictableTree tree;

    public LRUEvictionPolicy(EvictableTree tree) {
        this.tree = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evict() {
        Map<NodeIdentifier, Object> map = this.queue;
        synchronized (map) {
            NodeIdentifier node;
            Iterator<NodeIdentifier> it = this.queue.keySet().iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while ((node = it.next()).isLocked());
            try {
                node.writeLock();
                try {
                    this.tree.evict(node);
                    this.queue.remove(node);
                }
                finally {
                    node.writeUnLock();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }
    }

    public void access(NodeIdentifier node) {
        if (this.queue.containsKey(node)) {
            this.queue.get(node);
        } else if (node.isValid()) {
            this.queue.put(node, null);
        }
    }
}

