/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.featurecache;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.caching.CacheOversizedException;
import org.geotools.caching.featurecache.FeatureCache;
import org.geotools.caching.util.BBoxFilterSplitter;
import org.geotools.caching.util.CacheUtil;
import org.geotools.data.DataAccess;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.OrImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.BBOX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureCache
implements FeatureCache,
FeatureListener {
    protected static Logger logger;
    protected static FilterFactory ff;
    protected SimpleFeatureSource fs;
    protected int source_hits = 0;
    protected int source_feature_reads = 0;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    static {
        ff = CommonFactoryFinder.getFilterFactory2(null);
        logger = Logging.getLogger((String)"org.geotools.caching");
    }

    public AbstractFeatureCache(SimpleFeatureSource fs) {
        this.fs = fs;
        fs.addFeatureListener((FeatureListener)this);
    }

    public void addFeatureListener(FeatureListener listener) {
        this.fs.addFeatureListener(listener);
    }

    public DataAccess getDataStore() {
        return this.fs.getDataStore();
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        String typename = query.getTypeName();
        String schemaname = this.getSchema().getTypeName();
        if (query.getTypeName() != null && typename != schemaname) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        SimpleFeatureCollection fc = this.getFeatures(query.getFilter());
        if (fc.size() == 0) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        query = new DefaultQuery(query.getTypeName(), query.getNamespace(), (Filter)Filter.INCLUDE, query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        MemoryDataStore md = new MemoryDataStore();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        SimpleFeatureIterator it = fc.features();
        try {
            while (it.hasNext()) {
                SimpleFeature type = (SimpleFeature)it.next();
                features.add(type);
            }
        }
        finally {
            it.close();
        }
        md.addFeatures(features.toArray(new SimpleFeature[features.size()]));
        FeatureReader fr = md.getFeatureReader(query, Transaction.AUTO_COMMIT);
        DefaultFeatureCollection fc1 = new DefaultFeatureCollection("cachedfeaturecollection", (SimpleFeatureType)fr.getFeatureType());
        while (fr.hasNext()) {
            fc1.add((Feature)((SimpleFeature)fr.next()));
        }
        fr.close();
        return fc1;
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        SimpleFeatureCollection fc;
        BBoxFilterSplitter splitter = new BBoxFilterSplitter();
        filter.accept((FilterVisitor)splitter, null);
        Filter spatial_restrictions = splitter.getFilterPre();
        Filter other_restrictions = splitter.getFilterPost();
        if (spatial_restrictions == Filter.EXCLUDE) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (spatial_restrictions == Filter.INCLUDE) {
            return this.fs.getFeatures(filter);
        }
        try {
            fc = this._getFeatures(spatial_restrictions);
        }
        catch (UnsupportedOperationException e) {
            logger.log(Level.WARNING, "Querying cache : " + e.toString());
            return this.fs.getFeatures(filter);
        }
        return fc.subCollection(other_restrictions);
    }

    protected SimpleFeatureCollection _getFeatures(Filter filter) throws IOException {
        if (filter instanceof BBOXImpl) {
            return this.get(CacheUtil.extractEnvelope((BBOXImpl)filter)).subCollection(filter);
        }
        throw new UnsupportedOperationException("Cannot handle given filter :" + filter);
    }

    @Override
    public SimpleFeatureCollection get(Envelope e) throws IOException {
        SimpleFeatureCollection fromCache;
        List<Envelope> notcached = null;
        String geometryname = this.getSchema().getGeometryDescriptor().getLocalName();
        String srs = this.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem().toString();
        this.lock.readLock().lock();
        try {
            notcached = this.match(e);
            if (notcached.isEmpty()) {
                SimpleFeatureCollection fromCache2;
                SimpleFeatureCollection simpleFeatureCollection = fromCache2 = this.peek(e);
                return simpleFeatureCollection;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            SimpleFeatureCollection fromSource;
            notcached = this.match(e);
            if (notcached.isEmpty()) {
                SimpleFeatureCollection fromCache3;
                SimpleFeatureCollection simpleFeatureCollection = fromCache3 = this.peek(e);
                return simpleFeatureCollection;
            }
            fromCache = this.peek(e);
            Or filter = null;
            if (notcached.size() == 1) {
                Envelope env = notcached.get(0);
                filter = ff.bbox(geometryname, env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), srs);
            } else {
                ArrayList<BBOX> filters = new ArrayList<BBOX>(notcached.size());
                for (Envelope next : notcached) {
                    BBOX bbox = ff.bbox(geometryname, next.getMinX(), next.getMinY(), next.getMaxX(), next.getMaxY(), srs);
                    filters.add(bbox);
                }
                filter = ff.or(filters);
            }
            try {
                MemoryFeatureCollection localSource = new MemoryFeatureCollection(this.getSchema());
                fromSource = this.fs.getFeatures((Filter)filter);
                localSource.addAll((FeatureCollection)fromSource);
                fromSource = localSource;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Error getting data for cache from source feature store.", ex);
                SimpleFeatureCollection simpleFeatureCollection = fromCache;
                this.lock.writeLock().unlock();
                return simpleFeatureCollection;
            }
            ++this.source_hits;
            this.source_feature_reads += fromSource.size();
            fromCache.addAll((FeatureCollection)fromSource);
            try {
                this.isOversized((FeatureCollection)fromSource);
                try {
                    this.register((Filter)filter);
                    this.put(fromCache);
                }
                catch (Exception ex) {
                    this.unregister((Filter)filter);
                }
            }
            catch (CacheOversizedException e1) {
                logger.log(Level.INFO, "Adding data to cache : " + e1.toString());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return fromCache;
    }

    protected abstract List<Envelope> match(Envelope var1);

    protected void register(BBOXImpl f) {
        this.register(CacheUtil.extractEnvelope(f));
    }

    protected abstract void register(Envelope var1);

    protected abstract void unregister(Envelope var1);

    protected void unregister(BBOXImpl f) {
        this.unregister(CacheUtil.extractEnvelope(f));
    }

    public void unregister(Filter f) {
        if (f instanceof OrImpl) {
            for (Filter child : ((OrImpl)f).getChildren()) {
                this.unregister(child);
            }
        } else if (f instanceof BBOXImpl) {
            this.unregister((BBOXImpl)f);
        } else {
            throw new UnsupportedOperationException("Do not know how to handle this filter" + f);
        }
    }

    protected abstract void isOversized(FeatureCollection var1) throws CacheOversizedException;

    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.fs.getSchema();
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.fs.removeFeatureListener(listener);
    }

    public void changed(FeatureEvent event) {
        this.remove((Envelope)event.getBounds());
    }

    public void register(Filter f) {
        if (f instanceof OrImpl) {
            for (Filter child : ((OrImpl)f).getChildren()) {
                this.register(child);
            }
        } else if (f instanceof BBOXImpl) {
            this.register((BBOXImpl)f);
        } else {
            throw new UnsupportedOperationException("Do not know how to handle this filter" + f);
        }
    }

    public String sourceAccessStats() {
        StringBuffer sb = new StringBuffer();
        sb.append("Source hits = " + this.source_hits);
        sb.append(" ; Feature reads = " + this.source_feature_reads);
        return sb.toString();
    }

    public abstract String getStats();

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnLock() {
        this.lock.readLock().unlock();
    }

    public void writeLock() {
        this.lock.writeLock().lock();
    }

    public void writeUnLock() {
        this.lock.writeLock().unlock();
    }

    public ResourceInfo getInfo() {
        return this.fs.getInfo();
    }

    public Name getName() {
        return this.fs.getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.fs.getQueryCapabilities();
    }
}

