/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.caching.grid.spatialindex.GridNode;
import org.geotools.caching.grid.spatialindex.GridSpatialIndex;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.RegionNodeIdentifier;
import org.geotools.caching.spatialindex.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridRootNode
extends GridNode {
    private static final long serialVersionUID = 4675163856302389522L;
    protected double tiles_size;
    protected int[] tiles_number;
    protected ArrayList<NodeIdentifier> children;
    protected int childrenCapacity = -1;

    GridRootNode() {
    }

    protected GridRootNode(int gridsize, RegionNodeIdentifier id) {
        super(id);
        this.init(gridsize);
    }

    private void init(int gridsize) {
        int dims = this.getShape().getDimension();
        Region mbr = (Region)this.getShape();
        this.tiles_number = new int[dims];
        double area = 1.0;
        int i = 0;
        while (i < dims) {
            area *= mbr.getHigh(i) - mbr.getLow(i);
            ++i;
        }
        this.tiles_size = Math.pow(area / (double)gridsize, 1.0 / (double)dims);
        int newcapacity = 1;
        int i2 = 0;
        while (i2 < dims) {
            double dtmp = (mbr.getHigh(i2) - mbr.getLow(i2)) / this.tiles_size;
            int tmp = (int)dtmp;
            if ((double)tmp < dtmp) {
                // empty if block
            }
            this.tiles_number[i2] = ++tmp;
            newcapacity *= tmp;
            ++i2;
        }
        assert (newcapacity >= gridsize);
        this.childrenCapacity = newcapacity;
        this.children = new ArrayList(this.childrenCapacity);
    }

    protected void split(GridSpatialIndex index) {
        int dims = this.tiles_number.length;
        double[] pos = new double[dims];
        double[] nextpos = new double[dims];
        Region mbr = (Region)this.getShape();
        int i = 0;
        while (i < dims) {
            pos[i] = mbr.getLow(i);
            nextpos[i] = pos[i] + this.tiles_size;
            ++i;
        }
        do {
            Region reg = new Region(pos, nextpos);
            RegionNodeIdentifier id = (RegionNodeIdentifier)index.findUniqueInstance(new RegionNodeIdentifier(reg));
            GridNode child = this.createNode(id);
            index.writeNode(child);
            this.children.add(child.getIdentifier());
        } while (this.increment(pos, nextpos));
    }

    public List<Integer> getChildren(Shape shape) {
        Region mbr = (Region)this.getShape();
        Region childMBR = shape.getMBR();
        int dims = mbr.getDimension();
        int[] gridminindex = new int[dims];
        int i = 0;
        while (i < gridminindex.length) {
            gridminindex[i] = childMBR.getLow(i) <= mbr.getLow(i) ? 0 : (int)Math.floor((childMBR.getLow(i) - mbr.getLow(i)) / this.tiles_size);
            ++i;
        }
        int[] gridmaxindex = new int[dims];
        int i2 = 0;
        while (i2 < gridminindex.length) {
            gridmaxindex[i2] = childMBR.getHigh(i2) >= mbr.getHigh(i2) ? this.tiles_number[i2] - 1 : (int)Math.floor((childMBR.getHigh(i2) - mbr.getLow(i2)) / this.tiles_size);
            ++i2;
        }
        int[] current = (int[])gridminindex.clone();
        return this.iterate(current, gridminindex, gridmaxindex, 0);
    }

    private List<Integer> iterate(int[] current, int[] min, int[] max, int index) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (index >= min.length) {
            return Collections.singletonList(new Integer(this.gridIndexToNodeId(current)));
        }
        int i = min[index];
        while (i <= max[index]) {
            current[index] = i++;
            values.addAll(this.iterate(current, min, max, index + 1));
        }
        return values;
    }

    protected GridNode createNode(RegionNodeIdentifier id) {
        return new GridNode(id);
    }

    boolean increment(double[] pos, double[] nextpos) {
        Region mbr = (Region)this.getShape();
        int dims = pos.length;
        if (dims != this.tiles_number.length || nextpos.length != this.tiles_number.length) {
            throw new IllegalArgumentException("Cursor has not the same dimension as grid.");
        }
        int i = 0;
        while (i < dims) {
            if (!(nextpos[i] - mbr.getHigh(i) > 0.0) && !(Math.abs(nextpos[i] - mbr.getHigh(i)) < 1.192092896E-7)) {
                pos[i] = nextpos[i];
                nextpos[i] = pos[i] + this.tiles_size;
                break;
            }
            pos[i] = mbr.getLow(i);
            nextpos[i] = pos[i] + this.tiles_size;
            if (i == dims - 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GridRootNode: MBR: " + this.getShape() + ", capacity: " + this.getCapacity());
        return sb.toString();
    }

    @Override
    public NodeIdentifier getChildIdentifier(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    public void setChildIdentifier(int index, NodeIdentifier id) {
        this.children.set(index, id);
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public boolean isIndex() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return !this.isIndex();
    }

    public int gridIndexToNodeId(int[] index) {
        if (index.length != this.tiles_number.length) {
            throw new IllegalArgumentException("Argument has " + index.length + " dimensions whereas grid has " + this.tiles_number.length);
        }
        int result = 0;
        int offset = 1;
        int i = 0;
        while (i < index.length) {
            result += offset * index[i];
            offset *= this.tiles_number[i];
            ++i;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String toReadableText() {
        StringBuffer sb = new StringBuffer();
        sb.append("RootNode *****");
        sb.append(super.toReadableText());
        return sb.toString();
    }

    public int getCapacity() {
        return this.childrenCapacity;
    }

    public int getMaximumTileCount(int dim) {
        if (dim < 0 || dim > this.tiles_number.length) {
            return -1;
        }
        return this.tiles_number[dim];
    }

    public double getTileSize() {
        return this.tiles_size;
    }
}

