/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex.store;

import java.util.Properties;
import org.geotools.caching.grid.spatialindex.store.BufferedDiskStorage;
import org.geotools.caching.grid.spatialindex.store.DiskStorage;
import org.geotools.caching.grid.spatialindex.store.MemoryStorage;
import org.geotools.caching.spatialindex.Storage;

public class StorageFactory {
    private static StorageFactory instance = null;

    public static StorageFactory getInstance() {
        if (instance == null) {
            instance = new StorageFactory();
        }
        return instance;
    }

    public Storage createStorage(Properties pset) {
        String type = pset.getProperty("Storage.Type");
        if (type == null) {
            throw new IllegalArgumentException("Storage : Invalid property set.");
        }
        if (type.equals(MemoryStorage.class.getCanonicalName())) {
            return MemoryStorage.createInstance(pset);
        }
        if (type.equals(DiskStorage.class.getCanonicalName())) {
            return DiskStorage.createInstance(pset);
        }
        if (type.equals(BufferedDiskStorage.class.getCanonicalName())) {
            return BufferedDiskStorage.createInstance(pset);
        }
        return MemoryStorage.createInstance();
    }
}

