/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.util;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Stack;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBoxFilterSplitter
implements FilterVisitor {
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private static final Envelope UNIVERSE_ENVELOPE = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final Envelope EMPTY_ENVELOPE = new Envelope();
    private Stack<Envelope> envelopes = new Stack();
    private Stack<Filter> otherRestrictions = new Stack();
    private String geom = null;
    private String srs = null;

    public Object visit(ExcludeFilter f, Object arg1) {
        this.envelopes.push(new Envelope(EMPTY_ENVELOPE));
        return null;
    }

    public Object visit(IncludeFilter f, Object arg1) {
        this.envelopes.push(new Envelope(UNIVERSE_ENVELOPE));
        return null;
    }

    public Object visit(Id f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(Not f, Object arg1) {
        f.getFilter().accept((FilterVisitor)this, arg1);
        if (this.envelopes.size() > 0) {
            this.envelopes.pop();
            this.envelopes.push(new Envelope(UNIVERSE_ENVELOPE));
        }
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(And f, Object arg1) {
        int envSize = this.envelopes.size();
        int othSize = this.otherRestrictions.size();
        for (Filter child : f.getChildren()) {
            child.accept((FilterVisitor)this, arg1);
        }
        if (this.envelopes.size() >= envSize + 2) {
            Envelope e = this.envelopes.pop();
            int i = this.envelopes.size();
            while (i > envSize) {
                Envelope curr = this.envelopes.pop();
                if (curr.equals((Object)EMPTY_ENVELOPE) || e.equals((Object)EMPTY_ENVELOPE)) {
                    e = new Envelope(EMPTY_ENVELOPE);
                } else if (!curr.equals((Object)UNIVERSE_ENVELOPE)) {
                    if (e.equals((Object)UNIVERSE_ENVELOPE)) {
                        e = curr;
                    } else {
                        e.expandToInclude(curr);
                    }
                }
                --i;
            }
            this.envelopes.push(e);
        }
        this.multiplePop(this.otherRestrictions, othSize);
        Envelope top = this.envelopes.peek();
        if (!top.equals((Object)EMPTY_ENVELOPE)) {
            this.otherRestrictions.push((Filter)f);
        }
        return null;
    }

    public Object visit(Or f, Object arg1) {
        int envSize = this.envelopes.size();
        int othSize = this.otherRestrictions.size();
        for (Filter child : f.getChildren()) {
            child.accept((FilterVisitor)this, arg1);
        }
        if (this.envelopes.size() > envSize + 1) {
            Envelope e = this.envelopes.pop();
            int i = this.envelopes.size();
            while (i > envSize) {
                e.expandToInclude(this.envelopes.pop());
                --i;
            }
            this.envelopes.push(e);
        } else if (this.envelopes.size() == envSize + 1) {
            this.envelopes.pop();
            this.envelopes.push(new Envelope(UNIVERSE_ENVELOPE));
        }
        int size = this.otherRestrictions.size();
        this.multiplePop(this.otherRestrictions, othSize);
        if (size > othSize) {
            this.otherRestrictions.push((Filter)f);
        }
        return null;
    }

    public Object visit(PropertyIsBetween f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsEqualTo f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsNotEqualTo f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsGreaterThan f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsLessThan f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsLessThanOrEqualTo f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsLike f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(PropertyIsNull f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(BBOX f, Object arg1) {
        if (this.geom == null) {
            if (f.getExpression1() instanceof PropertyName) {
                this.geom = ((PropertyName)f.getExpression1()).getPropertyName();
            }
            this.srs = f.getSRS();
        } else {
            String newgeom = f.getExpression1() instanceof PropertyName ? ((PropertyName)f.getExpression1()).getPropertyName() : null;
            String newsrs = f.getSRS();
            if (this.geom != newgeom || this.srs != this.srs) {
                throw new UnsupportedOperationException("This splitter can not be used against a filter where different BBOX filters refer to different Geometry attributes.");
            }
        }
        Envelope e = new Envelope(f.getMinX(), f.getMaxX(), f.getMinY(), f.getMaxY());
        this.envelopes.push(e);
        return null;
    }

    public Object visit(Beyond f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(Contains f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(Crosses f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(Disjoint f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(DWithin f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    public Object visit(Equals f, Object arg1) {
        this.otherRestrictions.push((Filter)f);
        return null;
    }

    protected void traverse(BinarySpatialOperator f) {
        if (f.getExpression1() instanceof Literal) {
            Literal l = (Literal)f.getExpression1();
            Geometry g = (Geometry)l.getValue();
            this.envelopes.push(g.getEnvelopeInternal());
        } else if (f.getExpression2() instanceof Literal) {
            Literal l = (Literal)f.getExpression2();
            Geometry g = (Geometry)l.getValue();
            this.envelopes.push(g.getEnvelopeInternal());
        }
        if (f.getExpression1() instanceof PropertyName) {
            this.geom = ((PropertyName)f.getExpression1()).getPropertyName();
        } else if (f.getExpression2() instanceof PropertyName) {
            this.geom = ((PropertyName)f.getExpression2()).getPropertyName();
        }
        this.otherRestrictions.push((Filter)f);
    }

    public Object visit(Intersects f, Object arg1) {
        this.traverse((BinarySpatialOperator)f);
        return null;
    }

    public Object visit(Overlaps f, Object arg1) {
        this.traverse((BinarySpatialOperator)f);
        return null;
    }

    public Object visit(Touches f, Object arg1) {
        this.traverse((BinarySpatialOperator)f);
        return null;
    }

    public Object visit(Within f, Object arg1) {
        this.traverse((BinarySpatialOperator)f);
        return null;
    }

    public Object visitNullFilter(Object arg0) {
        return null;
    }

    public Envelope getEnvelope() {
        assert (this.envelopes.size() < 2);
        if (this.envelopes.isEmpty()) {
            return null;
        }
        return this.envelopes.peek();
    }

    public Filter getFilterPre() {
        Envelope e = this.getEnvelope();
        if (e == null || e.isNull()) {
            return Filter.EXCLUDE;
        }
        if (e.equals((Object)UNIVERSE_ENVELOPE)) {
            return Filter.INCLUDE;
        }
        BBOX myfilter = filterFactory.bbox(this.geom, e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), this.srs);
        return myfilter;
    }

    public Filter getFilterPost() {
        if (this.otherRestrictions.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (this.otherRestrictions.size() == 1) {
            return this.otherRestrictions.peek();
        }
        return filterFactory.and(this.otherRestrictions.subList(0, this.otherRestrictions.size() - 1));
    }

    private void multiplePop(Stack<Filter> s, int downsize) {
        int i = s.size();
        while (i > downsize) {
            s.pop();
            --i;
        }
    }
}

