/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.caching.grid.spatialindex.store.DiskStorage;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedDiskStorage
implements Storage {
    public static final String BUFFER_SIZE_PROPERTY = "BufferedDiskStorage.BufferSize";
    protected static Logger logger = Logging.getLogger((String)"org.geotools.caching.spatialindex.store");
    private DiskStorage storage;
    private Map<NodeIdentifier, Node> buffer;
    private Set<Node> dirtyNodes;
    private int buffer_size;

    private BufferedDiskStorage(int buffersize) {
        this.buffer_size = buffersize;
        this.buffer = Collections.synchronizedMap(new LinkedHashMap(this.buffer_size, 0.75f, true));
        this.dirtyNodes = Collections.synchronizedSet(new HashSet());
    }

    public static Storage createInstance(Properties pset) {
        try {
            int buffer_size = Integer.parseInt(pset.getProperty(BUFFER_SIZE_PROPERTY));
            BufferedDiskStorage instance = new BufferedDiskStorage(buffer_size);
            instance.storage = (DiskStorage)DiskStorage.createInstance(pset);
            return instance;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("BufferedDiskStorage : invalid property set.", e);
        }
    }

    public static Storage createInstance() {
        BufferedDiskStorage instance = new BufferedDiskStorage(100);
        instance.storage = (DiskStorage)DiskStorage.createInstance();
        return instance;
    }

    @Override
    public void clear() {
        this.dirtyNodes.clear();
        this.buffer.clear();
        this.storage.clear();
    }

    @Override
    public void dispose() {
        this.storage.dispose();
    }

    @Override
    public Node get(NodeIdentifier id) {
        Node ret = this.buffer.get(id);
        if (ret == null && (ret = this.storage.get(id)) != null) {
            this.put(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putNode(Node entry) {
        if (entry != null) {
            if (this.buffer.size() == this.buffer_size) {
                Map<NodeIdentifier, Node> map = this.buffer;
                synchronized (map) {
                    Iterator<NodeIdentifier> it = this.buffer.keySet().iterator();
                    this.buffer.remove(it.next());
                }
                this.buffer.put(entry.getIdentifier(), entry);
            } else {
                this.buffer.put(entry.getIdentifier(), entry);
            }
        }
    }

    @Override
    public void put(Node n) {
        if (this.buffer.containsKey(n.getIdentifier())) {
            this.dirtyNodes.add(n);
        } else {
            this.putNode(n);
            this.dirtyNodes.add(n);
        }
    }

    @Override
    public void remove(NodeIdentifier id) {
        if (this.buffer.containsKey(id)) {
            this.buffer.remove(id);
        } else {
            this.storage.remove(id);
        }
    }

    @Override
    public Properties getPropertySet() {
        Properties pset = this.storage.getPropertySet();
        pset.setProperty("Storage.Type", BufferedDiskStorage.class.getCanonicalName());
        pset.setProperty(BUFFER_SIZE_PROPERTY, new Integer(this.buffer_size).toString());
        return pset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Set<Node> set = this.dirtyNodes;
        synchronized (set) {
            for (Node entry : this.dirtyNodes) {
                this.storage.put(entry);
            }
            this.dirtyNodes.clear();
        }
        this.storage.flush();
    }

    @Override
    public NodeIdentifier findUniqueInstance(NodeIdentifier id) {
        if (this.buffer.containsKey(id)) {
            return this.buffer.get(id).getIdentifier();
        }
        return this.storage.findUniqueInstance(id);
    }

    @Override
    public void addFeatureType(FeatureType ft) {
        this.storage.addFeatureType(ft);
    }

    @Override
    public Collection<FeatureType> getFeatureTypes() {
        return this.storage.getFeatureTypes();
    }

    @Override
    public void clearFeatureTypes() {
        this.storage.clearFeatureTypes();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.storage.getBounds();
    }

    @Override
    public void setBounds(ReferencedEnvelope bounds) {
        this.storage.setBounds(bounds);
    }
}

