/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.spatialindex;

import java.util.LinkedList;

public class RWLock {
    private int active_readers;
    private int waiting_readers;
    private int active_writers;
    private final LinkedList writer_locks = new LinkedList();

    public synchronized void read_lock() {
        if (this.active_writers == 0 && this.writer_locks.size() == 0) {
            ++this.active_readers;
        } else {
            ++this.waiting_readers;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean read_lock_noblock() {
        if (this.active_writers == 0 && this.writer_locks.size() == 0) {
            ++this.active_readers;
            return true;
        }
        return false;
    }

    public synchronized void read_unlock() {
        if (--this.active_readers == 0) {
            this.notify_writers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write_lock() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            RWLock rWLock = this;
            synchronized (rWLock) {
                boolean okay_to_write;
                boolean bl = okay_to_write = this.writer_locks.size() == 0 && this.active_readers == 0 && this.active_writers == 0;
                if (okay_to_write) {
                    ++this.active_writers;
                    return;
                }
                this.writer_locks.addLast(lock);
            }
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean write_lock_noblock() {
        if (this.writer_locks.size() == 0 && this.active_readers == 0 && this.active_writers == 0) {
            ++this.active_writers;
            return true;
        }
        return false;
    }

    public synchronized void write_unlock() {
        --this.active_writers;
        if (this.waiting_readers > 0) {
            this.notify_readers();
        } else {
            this.notify_writers();
        }
    }

    private void notify_readers() {
        this.active_readers += this.waiting_readers;
        this.waiting_readers = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_writers() {
        if (this.writer_locks.size() > 0) {
            Object oldest = this.writer_locks.removeFirst();
            ++this.active_writers;
            Object e = oldest;
            synchronized (e) {
                oldest.notify();
            }
        }
    }
}

