/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.featurecache;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.geotools.caching.CacheOversizedException;
import org.geotools.caching.featurecache.FeatureCacheException;
import org.geotools.caching.grid.featurecache.GridFeatureCache;
import org.geotools.caching.grid.featurecache.readers.GridCachingFeatureCollection;
import org.geotools.caching.grid.spatialindex.NodeLockInvalidatingVisitor;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.caching.util.BBoxFilterSplitter;
import org.geotools.caching.util.CacheUtil;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.spatial.BBOX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingGridFeatureCache
extends GridFeatureCache {
    public StreamingGridFeatureCache(SimpleFeatureSource fs, int indexcapacity, int capacity, Storage store) throws FeatureCacheException {
        super(fs, indexcapacity, capacity, store);
    }

    public StreamingGridFeatureCache(SimpleFeatureSource fs, ReferencedEnvelope env, int indexcapacity, int capacity, Storage store) {
        super(fs, env, indexcapacity, capacity, store);
    }

    @Override
    public SimpleFeatureCollection get(Envelope e) throws IOException {
        BBOX f = ff.bbox(this.getSchema().getGeometryDescriptor().getLocalName(), e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), this.getSchema().getCoordinateReferenceSystem().toString());
        return this.getFeatures((Filter)f);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        if (query.getTypeName() == null) {
            query = new DefaultQuery(query);
            ((DefaultQuery)query).setTypeName(this.getSchema().getTypeName());
        } else if (!query.getTypeName().equals(this.getSchema().getTypeName())) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        Filter[] filters = this.splitFilter(query.getFilter());
        Filter envFilter = filters[0];
        if (envFilter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (envFilter.equals(Filter.INCLUDE)) {
            envFilter = this.createFilterFromBounds();
            return new GridCachingFeatureCollection((BBOX)envFilter, query, (GridFeatureCache)this, this.fs, true);
        }
        if (envFilter instanceof BBOX) {
            return new GridCachingFeatureCollection((BBOX)envFilter, query, (GridFeatureCache)this, this.fs, true);
        }
        throw new UnsupportedOperationException("Invalid filter created.");
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        Filter[] filters = this.splitFilter(filter);
        Filter envFilter = filters[0];
        if (envFilter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (envFilter.equals(Filter.INCLUDE)) {
            envFilter = this.createFilterFromBounds();
            return this.generateFeatureCollection((BBOX)envFilter, filter);
        }
        if (envFilter instanceof BBOX) {
            SimpleFeatureCollection fc = this.generateFeatureCollection((BBOX)envFilter, filter);
            return fc;
        }
        throw new UnsupportedOperationException("Invalid filter created.");
    }

    private BBOX createFilterFromBounds() throws IOException {
        ReferencedEnvelope env = this.getBounds();
        BBOX myfilter = ff.bbox(this.getSchema().getGeometryDescriptor().getLocalName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), this.getSchema().getCoordinateReferenceSystem().toString());
        return myfilter;
    }

    private SimpleFeatureCollection generateFeatureCollection(BBOX envFilter, Filter postFilter) {
        GridCachingFeatureCollection collection = new GridCachingFeatureCollection(envFilter, postFilter, (GridFeatureCache)this, this.fs, true);
        return collection;
    }

    private SimpleFeatureCollection generateFeatureCollection(Envelope env) {
        GridCachingFeatureCollection collection = new GridCachingFeatureCollection(env, this);
        return collection;
    }

    private Filter[] splitFilter(Filter filter) {
        BBoxFilterSplitter splitter = new BBoxFilterSplitter();
        filter.accept((FilterVisitor)splitter, null);
        Filter spatial_restrictions = splitter.getFilterPre();
        Filter other_restrictions = splitter.getFilterPost();
        return new Filter[]{spatial_restrictions, other_restrictions};
    }

    @Override
    public SimpleFeatureCollection peek(Envelope e) {
        return this.generateFeatureCollection(e);
    }

    public void put(FeatureCollection fc, Envelope e) throws CacheOversizedException {
        throw new UnsupportedOperationException("Streaming feature cache does not put entire feature collections.");
    }

    public void put(FeatureCollection fc) throws CacheOversizedException {
        throw new UnsupportedOperationException("Streaming feature cache does not put entire feature collections.");
    }

    @Override
    public void remove(Envelope e) {
        NodeLockInvalidatingVisitor v = new NodeLockInvalidatingVisitor(this.tracker);
        try {
            if (e == null) {
                e = this.getBounds();
            }
            this.tracker.intersectionQuery(CacheUtil.convert(e), v);
            this.tracker.getStatistics().addToDataCounter(-v.getDataCount());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error removing elements from cache.", ex);
        }
        this.tracker.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Collection<NodeIdentifier> nodes) {
        boolean recordaccess = this.tracker.getDoRecordAccess();
        try {
            this.tracker.setDoRecordAccess(false);
            for (NodeIdentifier nodeIdentifier : nodes) {
                nodeIdentifier.setValid(true);
            }
        }
        finally {
            this.tracker.setDoRecordAccess(recordaccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Collection<NodeIdentifier> nodes) {
        boolean recordaccess = this.tracker.getDoRecordAccess();
        try {
            this.tracker.setDoRecordAccess(false);
            for (NodeIdentifier nodeIdentifier : nodes) {
                nodeIdentifier.setValid(false);
            }
        }
        finally {
            this.tracker.setDoRecordAccess(recordaccess);
        }
    }
}

