/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.spatialindex;

import java.util.Stack;
import org.geotools.caching.spatialindex.NearestNeighborComparator;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Point;
import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.Shape;
import org.geotools.caching.spatialindex.SpatialIndex;
import org.geotools.caching.spatialindex.SpatialIndexStatistics;
import org.geotools.caching.spatialindex.Statistics;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.caching.spatialindex.Visitor;

public abstract class AbstractSpatialIndex
implements SpatialIndex {
    public static final int ContainmentQuery = 1;
    public static final int IntersectionQuery = 2;
    protected NodeIdentifier root;
    protected Node rootNode = null;
    protected Storage store;
    protected int dimension;
    protected Region infiniteRegion;
    protected SpatialIndexStatistics stats = new SpatialIndexStatistics();

    public Storage getStorage() {
        return this.store;
    }

    public void intersectionQuery(Shape query, Visitor v) {
        if (query.getDimension() != this.dimension) {
            throw new IllegalArgumentException("intersectionQuery: Shape has the wrong number of dimensions.");
        }
        this.rangeQuery(2, query, v);
    }

    public void containmentQuery(Shape query, Visitor v) {
        if (query.getDimension() != this.dimension) {
            throw new IllegalArgumentException("containmentQuery: Shape has the wrong number of dimensions.");
        }
        this.rangeQuery(1, query, v);
    }

    public void pointLocationQuery(Point query, Visitor v) {
        if (query.getDimension() != this.dimension) {
            throw new IllegalArgumentException("pointLocationQuery: Shape has the wrong number of dimensions.");
        }
        Region r = new Region(query, query);
        this.rangeQuery(2, r, v);
    }

    protected void rangeQuery(int type, Shape query, Visitor v) {
        NodePointer current = null;
        Stack<NodePointer> notYetVisitedNodes = new Stack<NodePointer>();
        Stack<NodePointer> visitedNodes = new Stack<NodePointer>();
        if (query.intersects(this.root.getShape())) {
            current = new NodePointer(this.readNode(this.root));
            notYetVisitedNodes.push(current);
        }
        block0: while (!notYetVisitedNodes.isEmpty() || !visitedNodes.isEmpty()) {
            if (!notYetVisitedNodes.isEmpty()) {
                current = (NodePointer)notYetVisitedNodes.pop();
                v.visitNode(current.node);
                if (v.isDataVisitor()) {
                    this.visitData(current.node, v, query, type);
                }
            } else {
                current = (NodePointer)visitedNodes.pop();
            }
            while (current.hasNext()) {
                NodeIdentifier child = current.next();
                if (!query.intersects(child.getShape())) continue;
                Node n = this.readNode(child);
                NodePointer np = new NodePointer(n);
                notYetVisitedNodes.push(np);
                visitedNodes.push(current);
                continue block0;
            }
        }
    }

    protected abstract void visitData(Node var1, Visitor var2, Shape var3, int var4);

    public void nearestNeighborQuery(int k, Shape query, Visitor v, NearestNeighborComparator nnc) {
    }

    public void nearestNeighborQuery(int k, Shape query, Visitor v) {
    }

    public void insertData(Object data, Shape shape) {
        if (shape.getDimension() != this.dimension) {
            throw new IllegalArgumentException("insertData: Shape has the wrong number of dimensions.");
        }
        if (this.root.getShape().contains(shape)) {
            this.insertData(this.root, data, shape);
        } else {
            this.insertDataOutOfBounds(data, shape);
        }
    }

    protected abstract void insertData(NodeIdentifier var1, Object var2, Shape var3);

    protected abstract void insertDataOutOfBounds(Object var1, Shape var2);

    public Statistics getStatistics() {
        return this.stats;
    }

    protected Node readNode(NodeIdentifier id) {
        if (this.rootNode != null && id.equals(this.root)) {
            return this.rootNode;
        }
        Node ret = id.getNode();
        if (ret != null) {
            return ret;
        }
        ret = this.store.get(id);
        ++this.stats.stats_reads;
        id.setNode(ret);
        return ret;
    }

    protected void writeNode(Node node) {
        if (node.getIdentifier().equals(this.root)) {
            this.rootNode = node;
            return;
        }
        this.store.put(node);
        ++this.stats.stats_writes;
    }

    protected void deleteNode(NodeIdentifier id) {
        this.store.remove(id);
    }

    public synchronized void flush() {
        if (this.rootNode != null) {
            this.store.put(this.rootNode);
        }
        this.store.flush();
    }

    class NodePointer {
        Node node;
        int nextidx = 0;

        NodePointer(Node n) {
            this.node = n;
        }

        boolean hasNext() {
            return this.nextidx < this.node.getChildrenCount();
        }

        NodeIdentifier next() {
            if (this.hasNext()) {
                NodeIdentifier next = this.node.getChildIdentifier(this.nextidx);
                ++this.nextidx;
                return next;
            }
            return null;
        }
    }
}

