/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.spatialindex;

import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.Shape;

public class Point
implements Shape,
Cloneable {
    public double[] m_pCoords = null;

    public Point(double[] pCoords) {
        this.m_pCoords = new double[pCoords.length];
        System.arraycopy(pCoords, 0, this.m_pCoords, 0, pCoords.length);
    }

    public Point(Point pt) {
        this.m_pCoords = new double[pt.m_pCoords.length];
        System.arraycopy(pt.m_pCoords, 0, this.m_pCoords, 0, pt.m_pCoords.length);
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point pt = (Point)o;
            if (pt.m_pCoords.length != this.m_pCoords.length) {
                return false;
            }
            for (int cIndex = 0; cIndex < this.m_pCoords.length; ++cIndex) {
                if (!(this.m_pCoords[cIndex] < pt.m_pCoords[cIndex] - 1.192092896E-7) && !(this.m_pCoords[cIndex] > pt.m_pCoords[cIndex] + 1.192092896E-7)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        return new Point(this.m_pCoords);
    }

    public boolean intersects(Shape s) {
        if (s instanceof Region) {
            return ((Region)s).contains(this);
        }
        return false;
    }

    public boolean contains(Shape s) {
        return false;
    }

    public boolean touches(Shape s) {
        if (s instanceof Point && this.equals(s)) {
            return true;
        }
        if (s instanceof Region) {
            return ((Region)s).touches(this);
        }
        return false;
    }

    public double[] getCenter() {
        double[] pCoords = new double[this.m_pCoords.length];
        System.arraycopy(this.m_pCoords, 0, pCoords, 0, this.m_pCoords.length);
        return pCoords;
    }

    public int getDimension() {
        return this.m_pCoords.length;
    }

    public Region getMBR() {
        return new Region(this.m_pCoords, this.m_pCoords);
    }

    public double getArea() {
        return 0.0;
    }

    public double getMinimumDistance(Shape s) {
        if (s instanceof Region) {
            return ((Region)s).getMinimumDistance(this);
        }
        if (s instanceof Point) {
            return this.getMinimumDistance((Point)s);
        }
        throw new IllegalStateException("getMinimumDistance: Not implemented yet!");
    }

    double getMinimumDistance(Point p) {
        if (this.m_pCoords.length != p.m_pCoords.length) {
            throw new IllegalArgumentException("getMinimumDistance: Shape has the wrong number of dimensions.");
        }
        double ret = 0.0;
        for (int cIndex = 0; cIndex < this.m_pCoords.length; ++cIndex) {
            ret += Math.pow(this.m_pCoords[cIndex] - p.m_pCoords[cIndex], 2.0);
        }
        return Math.sqrt(ret);
    }

    public double getCoord(int index) throws IndexOutOfBoundsException {
        if (index >= this.m_pCoords.length) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.m_pCoords[index];
    }
}

