/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeatureMarshaller {
    public static final int FEATURE = -1;
    public static final int SIMPLEATTRIBUTE = 0;
    private HashMap<String, SimpleFeatureType> types = new HashMap();
    private HashMap<String, SimpleFeatureBuilder> builders = new HashMap();

    public void registerType(SimpleFeatureType type) {
        if (!this.types.containsKey(type.getName().getURI())) {
            this.types.put(type.getName().getURI(), type);
        }
    }

    private SimpleFeatureType typeLookUp(String typeName) {
        return this.types.get(typeName);
    }

    public void marshall(SimpleFeature f, ObjectOutput s) throws IOException {
        SimpleFeatureType type = f.getType();
        this.registerType(type);
        s.writeObject(type.getName().getURI());
        s.writeObject(f.getID());
        int natt = f.getAttributes().size();
        s.writeInt(natt);
        for (Object att : f.getAttributes()) {
            this.marshallSimpleAttribute(att, s);
        }
    }

    protected void marshallSimpleAttribute(Object o, ObjectOutput s) throws IOException {
        if (o instanceof Collection) {
            throw new IllegalArgumentException("Got instance of SimpleFeature with complex attributes.");
        }
        if (o instanceof SimpleFeature) {
            s.writeInt(-1);
            this.marshall((SimpleFeature)o, s);
        } else {
            s.writeInt(0);
            s.writeObject(o);
        }
    }

    public SimpleFeature unmarshall(ObjectInput s) throws IOException, ClassNotFoundException, IllegalAttributeException {
        String typeName = (String)s.readObject();
        SimpleFeatureType type = this.typeLookUp(typeName);
        if (type != null) {
            SimpleFeature f = this.unmarshall(s, type);
            if (f == null) {
                System.err.println("Returning null feature");
            }
            return f;
        }
        throw new IllegalStateException(typeName + " is not a registered type.");
    }

    protected SimpleFeature unmarshall(ObjectInput s, SimpleFeatureType type) throws IOException, ClassNotFoundException, IllegalAttributeException {
        String fid = (String)s.readObject();
        int natt = s.readInt();
        SimpleFeatureBuilder builder = this.lookupBuilder(type);
        if (natt != type.getAttributeCount()) {
            throw new IOException("Schema error");
        }
        for (int i = 0; i < natt; ++i) {
            builder.add(this.unmarshallSimpleAttribute(s));
        }
        return builder.buildFeature(fid);
    }

    private SimpleFeatureBuilder lookupBuilder(SimpleFeatureType type) {
        SimpleFeatureBuilder builder = this.builders.get(type.getName().getURI());
        if (builder == null) {
            builder = new SimpleFeatureBuilder(type);
            this.builders.put(type.getName().getURI(), builder);
        }
        return builder;
    }

    protected Object unmarshallSimpleAttribute(ObjectInput s) throws IOException, ClassNotFoundException, IllegalAttributeException {
        int m = s.readInt();
        Object att = null;
        if (m == 0) {
            att = s.readObject();
        } else if (m == -1) {
            SimpleFeature f = this.unmarshall(s);
            att = f;
        } else {
            throw new IllegalAttributeException(null, null, "Found complex attribute which is not legal for SimpleFeature.");
        }
        return att;
    }
}

