/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.spatialindex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.Shape;

public abstract class NodeIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long LOCK_TIMEOUT = 300L;
    private static final TimeUnit LOCK_TIMEOUT_UNITS = TimeUnit.SECONDS;
    private boolean valid = false;
    transient ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    transient SoftReference<Node> node;

    NodeIdentifier() {
    }

    public abstract Shape getShape();

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void writeLock() throws Exception {
        if (!this.lock.writeLock().tryLock(300L, LOCK_TIMEOUT_UNITS)) {
            throw new Exception("Timed out waiting for write lock on node.");
        }
    }

    public void writeUnLock() {
        this.lock.writeLock().unlock();
    }

    public void readLock() throws Exception {
        if (!this.lock.readLock().tryLock(300L, LOCK_TIMEOUT_UNITS)) {
            throw new Exception("Timed out waiting for read lock on node.");
        }
    }

    public void readUnLock() {
        this.lock.readLock().unlock();
    }

    public boolean isWritable() {
        return this.lock.getReadLockCount() == 0;
    }

    public boolean isLocked() {
        return this.lock.getReadLockCount() > 0 || this.lock.isWriteLocked();
    }

    public void setNode(Node n) {
        this.node = new SoftReference<Node>(n);
    }

    public Node getNode() {
        if (this.node == null) {
            return null;
        }
        return this.node.get();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeBoolean(this.valid);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.valid = stream.readBoolean();
        this.lock = new ReentrantReadWriteLock();
    }
}

