/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.spatialindex;

import java.io.Serializable;
import org.geotools.caching.spatialindex.Point;
import org.geotools.caching.spatialindex.Shape;

public class Region
implements Shape,
Serializable {
    private static final long serialVersionUID = 2627615073834425697L;
    private double[] m_pLow = null;
    private double[] m_pHigh = null;
    private volatile int hashCode = 0;

    public Region() {
    }

    public Region(double[] pLow, double[] pHigh) {
        if (pLow.length != pHigh.length) {
            throw new IllegalArgumentException("Region: arguments have different number of dimensions.");
        }
        this.m_pLow = new double[pLow.length];
        System.arraycopy(pLow, 0, this.m_pLow, 0, pLow.length);
        this.m_pHigh = new double[pHigh.length];
        System.arraycopy(pHigh, 0, this.m_pHigh, 0, pHigh.length);
    }

    public Region(Point low, Point high) {
        if (low.m_pCoords.length != high.m_pCoords.length) {
            throw new IllegalArgumentException("Region: arguments have different number of dimensions.");
        }
        this.m_pLow = new double[low.m_pCoords.length];
        System.arraycopy(low.m_pCoords, 0, this.m_pLow, 0, low.m_pCoords.length);
        this.m_pHigh = new double[high.m_pCoords.length];
        System.arraycopy(high.m_pCoords, 0, this.m_pHigh, 0, high.m_pCoords.length);
    }

    public Region(Region r) {
        this.m_pLow = new double[r.m_pLow.length];
        System.arraycopy(r.m_pLow, 0, this.m_pLow, 0, r.m_pLow.length);
        this.m_pHigh = new double[r.m_pHigh.length];
        System.arraycopy(r.m_pHigh, 0, this.m_pHigh, 0, r.m_pHigh.length);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Region) {
            Region r = (Region)o;
            if (r.m_pLow.length != this.m_pLow.length) {
                return false;
            }
            for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
                if (this.m_pLow[cIndex] == r.m_pLow[cIndex] && this.m_pHigh[cIndex] == r.m_pHigh[cIndex]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        return new Region(this.m_pLow, this.m_pHigh);
    }

    public boolean intersects(Shape s) {
        if (s instanceof Region) {
            return this.intersects((Region)s);
        }
        if (s instanceof Point) {
            return this.contains((Point)s);
        }
        throw new IllegalStateException("intersects: Not implemented yet!");
    }

    public boolean contains(Shape s) {
        if (s instanceof Region) {
            return this.contains((Region)s);
        }
        if (s instanceof Point) {
            return this.contains((Point)s);
        }
        throw new IllegalStateException("contains: Not implemented yet!");
    }

    public boolean touches(Shape s) {
        if (s instanceof Region) {
            return this.touches((Region)s);
        }
        if (s instanceof Point) {
            return this.touches((Point)s);
        }
        throw new IllegalStateException("touches: Not implemented yet!");
    }

    public double[] getCenter() {
        double[] pCoords = new double[this.m_pLow.length];
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            pCoords[cIndex] = (this.m_pLow[cIndex] + this.m_pHigh[cIndex]) / 2.0;
        }
        return pCoords;
    }

    public int getDimension() {
        return this.m_pLow.length;
    }

    public Region getMBR() {
        return new Region(this.m_pLow, this.m_pHigh);
    }

    public double getArea() {
        double area = 1.0;
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            area *= this.m_pHigh[cIndex] - this.m_pLow[cIndex];
        }
        return area;
    }

    public double getMinimumDistance(Shape s) {
        if (s instanceof Region) {
            return this.getMinimumDistance((Region)s);
        }
        if (s instanceof Point) {
            return this.getMinimumDistance((Point)s);
        }
        throw new IllegalStateException("getMinimumDistance: Not implemented yet!");
    }

    public boolean intersects(Region r) {
        if (this.m_pLow.length != r.m_pLow.length) {
            throw new IllegalArgumentException("intersects: Shape has the wrong number of dimensions.");
        }
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (!(this.m_pLow[cIndex] > r.m_pHigh[cIndex]) && !(this.m_pHigh[cIndex] < r.m_pLow[cIndex])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Region r) {
        if (this.m_pLow.length != r.m_pLow.length) {
            throw new IllegalArgumentException("contains: Shape has the wrong number of dimensions.");
        }
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (!(this.m_pLow[cIndex] > r.m_pLow[cIndex]) && !(this.m_pHigh[cIndex] < r.m_pHigh[cIndex])) continue;
            return false;
        }
        return true;
    }

    public boolean touches(Region r) {
        if (this.m_pLow.length != r.m_pLow.length) {
            throw new IllegalArgumentException("touches: Shape has the wrong number of dimensions.");
        }
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (!(this.m_pLow[cIndex] > r.m_pLow[cIndex] - 1.192092896E-7 && this.m_pLow[cIndex] < r.m_pLow[cIndex] + 1.192092896E-7) && (!(this.m_pHigh[cIndex] > r.m_pHigh[cIndex] - 1.192092896E-7) || !(this.m_pHigh[cIndex] < r.m_pHigh[cIndex] + 1.192092896E-7))) continue;
            return true;
        }
        return false;
    }

    public double getMinimumDistance(Region r) {
        if (this.m_pLow.length != r.m_pLow.length) {
            throw new IllegalArgumentException("getMinimumDistance: Shape has the wrong number of dimensions.");
        }
        double ret = 0.0;
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            double x = 0.0;
            if (r.m_pHigh[cIndex] < this.m_pLow[cIndex]) {
                x = Math.abs(r.m_pHigh[cIndex] - this.m_pLow[cIndex]);
            } else if (this.m_pHigh[cIndex] < r.m_pLow[cIndex]) {
                x = Math.abs(r.m_pLow[cIndex] - this.m_pHigh[cIndex]);
            }
            ret += x * x;
        }
        return Math.sqrt(ret);
    }

    public boolean contains(Point p) {
        if (this.m_pLow.length != p.m_pCoords.length) {
            throw new IllegalArgumentException("contains: Shape has the wrong number of dimensions.");
        }
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (!(this.m_pLow[cIndex] > p.m_pCoords[cIndex]) && !(this.m_pHigh[cIndex] < p.m_pCoords[cIndex])) continue;
            return false;
        }
        return true;
    }

    public boolean touches(Point p) {
        if (this.m_pLow.length != p.m_pCoords.length) {
            throw new IllegalArgumentException("touches: Shape has the wrong number of dimensions.");
        }
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (!(this.m_pLow[cIndex] > p.m_pCoords[cIndex] - 1.192092896E-7 && this.m_pLow[cIndex] < p.m_pCoords[cIndex] + 1.192092896E-7) && (!(this.m_pHigh[cIndex] > p.m_pCoords[cIndex] - 1.192092896E-7) || !(this.m_pHigh[cIndex] < p.m_pCoords[cIndex] + 1.192092896E-7))) continue;
            return true;
        }
        return false;
    }

    public double getMinimumDistance(Point p) {
        if (this.m_pLow.length != p.m_pCoords.length) {
            throw new IllegalArgumentException("getMinimumDistance: Shape has the wrong number of dimensions.");
        }
        double ret = 0.0;
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (p.m_pCoords[cIndex] < this.m_pLow[cIndex]) {
                ret += Math.pow(this.m_pLow[cIndex] - p.m_pCoords[cIndex], 2.0);
                continue;
            }
            if (!(p.m_pCoords[cIndex] > this.m_pHigh[cIndex])) continue;
            ret += Math.pow(p.m_pCoords[cIndex] - this.m_pHigh[cIndex], 2.0);
        }
        return Math.sqrt(ret);
    }

    public double getIntersectingArea(Region r) {
        int cIndex;
        if (this.m_pLow.length != r.m_pLow.length) {
            throw new IllegalArgumentException("getIntersectingArea: Shape has the wrong number of dimensions.");
        }
        for (cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            if (!(this.m_pLow[cIndex] > r.m_pHigh[cIndex]) && !(this.m_pHigh[cIndex] < r.m_pLow[cIndex])) continue;
            return 0.0;
        }
        double ret = 1.0;
        for (cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            double f1 = Math.max(this.m_pLow[cIndex], r.m_pLow[cIndex]);
            double f2 = Math.min(this.m_pHigh[cIndex], r.m_pHigh[cIndex]);
            ret *= f2 - f1;
        }
        return ret;
    }

    public Region combinedRegion(Region r) {
        if (this.m_pLow.length != r.m_pLow.length) {
            throw new IllegalArgumentException("combinedRegion: Shape has the wrong number of dimensions.");
        }
        double[] mn = new double[this.m_pLow.length];
        double[] mx = new double[this.m_pLow.length];
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            mn[cIndex] = Math.min(this.m_pLow[cIndex], r.m_pLow[cIndex]);
            mx[cIndex] = Math.max(this.m_pHigh[cIndex], r.m_pHigh[cIndex]);
        }
        return new Region(mn, mx);
    }

    public static Region combinedRegion(Region[] pRegions) {
        double[] mn = new double[pRegions[0].m_pLow.length];
        double[] mx = new double[pRegions[0].m_pLow.length];
        for (int cDim = 0; cDim < pRegions[0].m_pLow.length; ++cDim) {
            mn[cDim] = Double.POSITIVE_INFINITY;
            mx[cDim] = Double.NEGATIVE_INFINITY;
            for (int cIndex = 0; cIndex < pRegions.length; ++cIndex) {
                mn[cDim] = Math.min(mn[cDim], pRegions[cIndex].m_pLow[cDim]);
                mx[cDim] = Math.max(mx[cDim], pRegions[cIndex].m_pHigh[cDim]);
            }
        }
        return new Region(mn, mx);
    }

    public static void combinedRegion(Region pToModify, Region pConst) {
        if (pToModify.m_pLow.length != pConst.m_pLow.length) {
            throw new IllegalArgumentException("combineRegion: Shape has the wrong number of dimensions.");
        }
        for (int cIndex = 0; cIndex < pToModify.m_pLow.length; ++cIndex) {
            pToModify.m_pLow[cIndex] = Math.min(pToModify.m_pLow[cIndex], pConst.m_pLow[cIndex]);
            pToModify.m_pHigh[cIndex] = Math.max(pToModify.m_pHigh[cIndex], pConst.m_pHigh[cIndex]);
        }
    }

    public double getMargin() {
        double mul = Math.pow(2.0, (double)this.m_pLow.length - 1.0);
        double margin = 0.0;
        for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            margin += (this.m_pHigh[cIndex] - this.m_pLow[cIndex]) * mul;
        }
        return margin;
    }

    public double getLow(int index) throws IndexOutOfBoundsException {
        if (index >= this.m_pLow.length) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.m_pLow[index];
    }

    public double getHigh(int index) throws IndexOutOfBoundsException {
        if (index >= this.m_pLow.length) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.m_pHigh[index];
    }

    public String toString() {
        int cIndex;
        String s = "";
        for (cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
            s = s + this.m_pLow[cIndex] + " ";
        }
        s = s + ": ";
        for (cIndex = 0; cIndex < this.m_pHigh.length; ++cIndex) {
            s = s + this.m_pHigh[cIndex] + " ";
        }
        return s;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 17;
            for (int cIndex = 0; cIndex < this.m_pLow.length; ++cIndex) {
                long l = Double.doubleToLongBits(this.m_pLow[cIndex]);
                int c = (int)(l ^ l >>> 32);
                hash = 37 * hash + c;
                l = Double.doubleToLongBits(this.m_pHigh[cIndex]);
                c = (int)(l ^ l >>> 32);
                hash = 37 * hash + c;
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }
}

