/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import org.geotools.image.io.Palette;
import org.geotools.image.io.PaletteFactory;
import org.geotools.resources.image.ColorUtilities;

final class IndexedPalette
extends Palette {
    private static final int MAX_UNSIGNED = 65535;
    protected final int lower;
    protected final int upper;
    protected final int size;

    protected IndexedPalette(PaletteFactory factory, String name, int lower, int upper, int size, int numBands, int visibleBand) {
        super(factory, name, numBands, visibleBand);
        int maxAllowed;
        int minAllowed;
        if (lower < 0) {
            minAllowed = Short.MIN_VALUE;
            maxAllowed = Short.MAX_VALUE;
            size = size <= 256 ? 256 : 65536;
        } else {
            minAllowed = 0;
            maxAllowed = 65535;
        }
        this.ensureInsideBounds(lower, minAllowed, maxAllowed);
        this.ensureInsideBounds(upper, minAllowed, maxAllowed + 1);
        this.ensureInsideBounds(size, upper, 65536);
        if (lower >= upper) {
            throw new IllegalArgumentException(factory.getErrorResources().getString(13, (Object)lower, (Object)upper));
        }
        this.lower = lower;
        this.upper = upper;
        this.size = size;
    }

    double getScale() {
        return this.upper - this.lower;
    }

    double getOffset() {
        return this.lower;
    }

    private int[] createARGB() throws IOException {
        Color[] colors = this.factory.getColors(this.name);
        if (colors == null) {
            throw new FileNotFoundException(this.factory.getErrorResources().getString(36, (Object)this.name));
        }
        int[] ARGB = new int[this.size];
        if (this.lower >= 0) {
            ColorUtilities.expand((Color[])colors, (int[])ARGB, (int)this.lower, (int)this.upper);
        } else {
            ColorUtilities.expand((Color[])colors, (int[])ARGB, (int)0, (int)(this.upper - this.lower));
            int negativeStart = this.size + this.lower;
            int negativeCount = -this.lower;
            int[] negatives = new int[negativeCount];
            System.arraycopy(ARGB, 0, negatives, 0, negativeCount);
            System.arraycopy(ARGB, negativeCount, ARGB, 0, negativeStart);
            System.arraycopy(negatives, 0, ARGB, negativeStart, negativeCount);
        }
        return ARGB;
    }

    public synchronized ImageTypeSpecifier getImageTypeSpecifier() throws IOException {
        boolean dense;
        ImageTypeSpecifier its = this.queryCache();
        if (its != null) {
            return its;
        }
        int[] ARGB = this.createARGB();
        int bits = ColorUtilities.getBitCount((int)ARGB.length);
        int type = bits <= 8 ? 0 : 1;
        boolean packed = bits == 1 || bits == 2 || bits == 4;
        boolean bl = dense = packed || bits == 8 || bits == 16;
        if (dense && 1 << bits == ARGB.length && this.numBands == 1) {
            byte[] A = new byte[ARGB.length];
            byte[] R = new byte[ARGB.length];
            byte[] G = new byte[ARGB.length];
            byte[] B = new byte[ARGB.length];
            for (int i = 0; i < ARGB.length; ++i) {
                int code = ARGB[i];
                B[i] = (byte)(code & 0xFF);
                G[i] = (byte)((code >>>= 8) & 0xFF);
                R[i] = (byte)((code >>>= 8) & 0xFF);
                A[i] = (byte)((code >>>= 8) & 0xFF);
            }
            its = ImageTypeSpecifier.createIndexed(R, G, B, A, bits, type);
        } else {
            IndexColorModel colors = ColorUtilities.getIndexColorModel((int[])ARGB, (int)this.numBands, (int)this.visibleBand);
            SampleModel samples = packed ? new MultiPixelPackedSampleModel(type, 1, 1, bits) : new PixelInterleavedSampleModel(type, 1, 1, 1, 1, new int[1]);
            its = new ImageTypeSpecifier(colors, samples);
        }
        this.cache(its);
        return its;
    }

    public int hashCode() {
        return super.hashCode() + 37 * (this.lower + 37 * (this.upper + 37 * this.size));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IndexedPalette that = (IndexedPalette)object;
            return this.lower == that.lower && this.upper == that.upper && this.size == that.size;
        }
        return false;
    }

    public String toString() {
        return this.name + " [" + this.lower + "..." + (this.upper - 1) + "] size=" + this.size;
    }
}

