/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import org.geotools.image.io.metadata.Axis;
import org.geotools.image.io.metadata.ChildList;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.GeographicMetadataFormat;
import org.geotools.image.io.metadata.Identification;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.image.io.metadata.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageReferencing
extends MetadataAccessor {
    ChildList<Axis> cs;
    ChildList<Parameter> projection;
    private MetadataAccessor datum;
    private MetadataAccessor ellipsoid;
    private MetadataAccessor primeMeridian;
    private MetadataAccessor semiMajorAxis;
    private MetadataAccessor semiMinorAxis;
    private MetadataAccessor inverseFlattening;

    protected ImageReferencing(GeographicMetadata metadata) {
        super(metadata, "rectifiedGridDomain/crs", null);
    }

    public int getDimension() {
        return this.getCoordinateSystemAccessor().childCount();
    }

    public Identification getCoordinateReferenceSystem() {
        return new Identification(this);
    }

    public void setCoordinateReferenceSystem(String name, String type) {
        this.setAttributeAsString("name", name);
        this.setAttributeAsEnum("type", type, GeographicMetadataFormat.CRS_TYPES);
    }

    public Identification getCoordinateSystem() {
        return this.cs != null ? new Identification(this.cs) : null;
    }

    public void setCoordinateSystem(String name, String type) {
        ChildList<Axis> cs = this.getCoordinateSystemAccessor();
        cs.setAttributeAsString("name", name);
        cs.setAttributeAsEnum("type", type, GeographicMetadataFormat.CS_TYPES);
    }

    public Identification getDatum() {
        return this.datum != null ? new Identification(this.datum) : null;
    }

    public void setDatum(String name, String type) {
        MetadataAccessor datum = this.getDatumAccessor();
        datum.setAttributeAsString("name", name);
        datum.setAttributeAsEnum("type", type, GeographicMetadataFormat.DATUM_TYPES);
    }

    public String getEllipsoidName() {
        return this.ellipsoid != null ? this.ellipsoid.getAttributeAsString("name") : null;
    }

    public void setEllipsoidName(String name) {
        this.getEllipsoidAccessor().setAttributeAsString("name", name);
    }

    public String getEllipsoidUnit() {
        return this.ellipsoid != null ? this.ellipsoid.getAttributeAsString("unit") : null;
    }

    public void setEllipsoidUnit(String unit) {
        this.getEllipsoidAccessor().setAttributeAsString("unit", unit);
    }

    public double getSemiMajorAxis() {
        Double semiMajor = this.semiMajorAxis != null ? this.semiMajorAxis.getUserObject(Double.class) : null;
        return semiMajor == null ? Double.NaN : semiMajor;
    }

    public void setSemiMajorAxis(double value) {
        this.getSemiMajorAxisAccessor().setUserObject(value);
    }

    public double getSemiMinorAxis() {
        Double semiMinor = this.semiMinorAxis != null ? this.semiMinorAxis.getUserObject(Double.class) : null;
        return semiMinor == null ? Double.NaN : semiMinor;
    }

    public void setSemiMinorAxis(double value) {
        this.getSemiMinorAxisAccessor().setUserObject(value);
    }

    public double getInverseFlattening() {
        return this.inverseFlattening != null ? this.inverseFlattening.getUserObject(Double.class) : null;
    }

    public void setInverseFlattening(double value) {
        this.getInverseFlatteningAccessor().setUserObject(value);
    }

    public Axis getAxis(int index) throws IndexOutOfBoundsException {
        return this.getCoordinateSystemAccessor().getChild(index);
    }

    public Axis addAxis(String name, String direction, String units) {
        Axis axis = this.getCoordinateSystemAccessor().addChild();
        axis.setName(name);
        axis.setDirection(direction);
        axis.setUnits(units);
        return axis;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        return this.projection != null ? this.projection.getChild(index) : null;
    }

    public Parameter[] getParameters() {
        int size = this.projection != null ? this.projection.childCount() : 0;
        Parameter[] params = new Parameter[size];
        for (int i = 0; i < size; ++i) {
            params[i] = this.getProjectionAccessor().getChild(i);
        }
        return params;
    }

    public Parameter addParameter(String name, double value) {
        Parameter parameter = this.getProjectionAccessor().addChild();
        parameter.setName(name);
        parameter.setValue(value);
        return parameter;
    }

    public String getPrimeMeridianName() {
        return this.primeMeridian != null ? this.primeMeridian.getAttributeAsString("name") : null;
    }

    public void setPrimeMeridianName(String name) {
        this.getPrimeMeridianAccessor().setAttributeAsString("name", name);
    }

    public double getPrimeMeridianGreenwichLongitude() {
        Double green = this.primeMeridian != null ? this.primeMeridian.getAttributeAsDouble("greenwichLongitude") : null;
        return green == null ? Double.NaN : green;
    }

    public void setPrimeMeridianGreenwichLongitude(double greenwichLongitude) {
        this.getPrimeMeridianAccessor().setAttributeAsDouble("greenwichLongitude", greenwichLongitude);
    }

    public String getProjectionName() {
        return this.projection != null ? this.projection.getAttributeAsString("name") : null;
    }

    public void setProjectionName(String name) {
        this.getProjectionAccessor().setAttributeAsString("name", name);
    }

    @Deprecated
    public String getWKT() {
        return this.getAttributeAsString("WKT");
    }

    @Deprecated
    public void setWKT(String wkt) {
        this.setAttributeAsString("WKT", wkt);
    }

    private ChildList<Axis> getCoordinateSystemAccessor() {
        if (this.cs == null) {
            this.cs = new ChildList.Axes(this.metadata);
        }
        return this.cs;
    }

    private MetadataAccessor getDatumAccessor() {
        if (this.datum == null) {
            this.datum = new MetadataAccessor(this.metadata, "rectifiedGridDomain/crs/datum", null);
        }
        return this.datum;
    }

    private MetadataAccessor getEllipsoidAccessor() {
        if (this.ellipsoid == null) {
            this.ellipsoid = new MetadataAccessor(this.metadata, "rectifiedGridDomain/crs/datum/ellipsoid", null);
        }
        return this.ellipsoid;
    }

    private MetadataAccessor getInverseFlatteningAccessor() {
        if (this.inverseFlattening == null) {
            this.inverseFlattening = new MetadataAccessor(this.metadata, "rectifiedGridDomain/crs/datum/ellipsoid/secondDefiningParameter/inverseFlattening", null);
        }
        return this.inverseFlattening;
    }

    private MetadataAccessor getPrimeMeridianAccessor() {
        if (this.primeMeridian == null) {
            this.primeMeridian = new MetadataAccessor(this.metadata, "rectifiedGridDomain/crs/datum/primeMeridian", null);
        }
        return this.primeMeridian;
    }

    private ChildList<Parameter> getProjectionAccessor() {
        if (this.projection == null) {
            this.projection = new ChildList.Parameters(this.metadata);
        }
        return this.projection;
    }

    private MetadataAccessor getSemiMajorAxisAccessor() {
        if (this.semiMajorAxis == null) {
            this.semiMajorAxis = new MetadataAccessor(this.metadata, "rectifiedGridDomain/crs/datum/ellipsoid/semiMajorAxis", null);
        }
        return this.semiMajorAxis;
    }

    private MetadataAccessor getSemiMinorAxisAccessor() {
        if (this.semiMinorAxis == null) {
            this.semiMinorAxis = new MetadataAccessor(this.metadata, "rectifiedGridDomain/crs/datum/ellipsoid/secondDefiningParameter/semiMinorAxis", null);
        }
        return this.semiMinorAxis;
    }
}

