/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import javax.measure.unit.Unit;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.ImageReferencing;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Projection;

class MetadataWriter {
    private final GeographicMetadata metadata;

    public MetadataWriter(GeographicMetadata metadata) {
        this.metadata = metadata != null ? metadata : new GeographicMetadata();
    }

    public void fillMetadataTree(GridCoverage coverage) {
        ImageReferencing referencing = this.metadata.getReferencing();
        CoordinateReferenceSystem crs = MetadataWriter.getCoordinateReferenceSystem(coverage);
        Datum datum = MetadataWriter.getDatum(coverage);
        Ellipsoid ellipsoid = MetadataWriter.getEllipsoid(coverage);
        Projection projection = MetadataWriter.getProjection(coverage);
        referencing.setCoordinateReferenceSystem(crs.getName().getCode(), null);
        referencing.setDatum(datum.getName().getCode(), null);
        referencing.setEllipsoidName(ellipsoid.getName().getCode());
        referencing.setProjectionName(projection.getName().getCode());
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(GridCoverage coverage) {
        return coverage.getCoordinateReferenceSystem();
    }

    public static Datum getDatum(GridCoverage coverage) {
        return CRSUtilities.getDatum((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
    }

    public static Ellipsoid getEllipsoid(GridCoverage coverage) {
        return CRS.getEllipsoid((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
    }

    public static String getOperationMethod(GridCoverage coverage) {
        Projection projection = MetadataWriter.getProjection(coverage);
        return projection != null ? projection.getName().getCode() : null;
    }

    public static Projection getProjection(GridCoverage coverage) {
        ProjectedCRS crs = CRS.getProjectedCRS((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
        return crs != null ? crs.getConversionFromBase() : null;
    }

    public static Unit getUnit(GridCoverage coverage) {
        CoordinateSystem cs;
        Unit unit = null;
        CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem();
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            int i = cs.getDimension();
            while (--i >= 0) {
                Unit candidate = cs.getAxis(i).getUnit();
                if (candidate == null) continue;
                if (unit == null) {
                    unit = candidate;
                    continue;
                }
                if (unit.equals((Object)candidate)) continue;
                return null;
            }
        }
        return unit;
    }
}

