/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.util.Arrays;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.GeographicMetadataFormat;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.resources.XArray;
import org.geotools.util.NumberRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageGeometry
extends MetadataAccessor {
    private MetadataAccessor lowerCorner;
    private MetadataAccessor upperCorner;
    private MetadataAccessor cells;
    private MetadataAccessor low;
    private MetadataAccessor high;
    private MetadataAccessor localizationGrid;
    private MetadataAccessor pixelOrientation;

    protected ImageGeometry(GeographicMetadata metadata) {
        super(metadata, "rectifiedGridDomain", null);
    }

    public int getDimension() {
        int dim2;
        int dim1 = this.low != null ? this.low.getUserObject(int[].class).length : 0;
        int n = dim2 = this.cells != null ? this.cells.childCount() : 0;
        if (dim2 == 0) {
            return dim1;
        }
        if (dim1 == 0) {
            return dim2;
        }
        if (dim1 != dim2) {
            this.warning("getDimension", 68, new int[]{dim1, dim2});
        }
        return Math.min(dim1, dim2);
    }

    public NumberRange<Integer> getGridRange(int dimension) {
        int minimum = this.low != null ? this.low.getUserObject(int[].class)[dimension] : 0;
        int maximum = this.high != null ? this.high.getUserObject(int[].class)[dimension] : 0;
        return NumberRange.create((int)minimum, (boolean)true, (int)maximum, (boolean)true);
    }

    public void setGridRange(int dimension, int minimum, int maximum) {
        int oldLength;
        int[] lows = this.getLowAccessor().getUserObject(int[].class);
        int[] highs = this.getHighAccessor().getUserObject(int[].class);
        int length = dimension + 1;
        if (lows == null) {
            lows = new int[length];
        } else {
            oldLength = lows.length;
            if (length > oldLength) {
                lows = XArray.resize((int[])lows, (int)length);
            }
        }
        if (highs == null) {
            highs = new int[length];
        } else {
            oldLength = highs.length;
            if (length > oldLength) {
                highs = XArray.resize((int[])highs, (int)length);
            }
        }
        lows[dimension] = minimum;
        highs[dimension] = maximum;
        this.getLowAccessor().setUserObject(lows);
        this.getHighAccessor().setUserObject(highs);
    }

    public NumberRange<Double> getOrdinateRange(int dimension) {
        double lower = this.lowerCorner != null ? this.lowerCorner.getUserObject(double[].class)[dimension] : Double.NaN;
        double upper = this.upperCorner != null ? this.upperCorner.getUserObject(double[].class)[dimension] : Double.NaN;
        return new NumberRange(Double.class, (Number)lower, true, (Number)upper, true);
    }

    public void setOrdinateRange(int dimension, double minimum, double maximum) {
        int oldLength;
        double[] lowers = this.getLowerCornerAccessor().getUserObject(double[].class);
        double[] uppers = this.getUpperCornerAccessor().getUserObject(double[].class);
        int length = dimension + 1;
        if (lowers == null) {
            lowers = new double[length];
            Arrays.fill(lowers, Double.NaN);
        } else {
            oldLength = lowers.length;
            if (length > oldLength) {
                lowers = XArray.resize((double[])lowers, (int)length);
                Arrays.fill(lowers, oldLength, length, Double.NaN);
            }
        }
        if (uppers == null) {
            uppers = new double[length];
            Arrays.fill(uppers, Double.NaN);
        } else {
            oldLength = uppers.length;
            if (length > oldLength) {
                uppers = XArray.resize((double[])uppers, (int)length);
                Arrays.fill(uppers, oldLength, length, Double.NaN);
            }
        }
        lowers[dimension] = minimum;
        uppers[dimension] = maximum;
        this.getLowerCornerAccessor().setUserObject(lowers);
        this.getUpperCornerAccessor().setUserObject(uppers);
    }

    public double[] getOrdinates(int dimension) {
        if (this.localizationGrid == null) {
            return new double[0];
        }
        this.localizationGrid.selectChild(dimension);
        return (double[])this.getLocalizationGridAccessor().getUserObject();
    }

    public void setOrdinates(int dimension, double[] values) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                if (value < minimum) {
                    minimum = value;
                }
                if (!(value > maximum)) continue;
                maximum = value;
            }
        }
        this.setOrdinateRange(dimension, minimum, maximum);
        this.getLocalizationGridAccessor().selectChild(dimension);
        this.getLocalizationGridAccessor().setUserObject(values);
    }

    public void addOrdinates(int minIndex, double[] values) {
        int[] lows = this.getLowAccessor().getUserObject(int[].class);
        int[] highs = this.getHighAccessor().getUserObject(int[].class);
        if (lows != null && highs != null) {
            int last = Math.max(lows.length, highs.length);
            if (last != lows.length || last != highs.length) {
                this.warning("addOrdinates", 68, new int[]{lows.length, highs.length});
            }
            lows = XArray.resize((int[])lows, (int)(last + 1));
            highs = XArray.resize((int[])highs, (int)(last + 1));
            lows[last] = minIndex;
            highs[last] = minIndex + values.length - 1;
        } else {
            if (lows == null) {
                lows = new int[]{minIndex};
            }
            if (highs == null) {
                highs = new int[]{minIndex + values.length - 1};
            }
        }
        this.getLowAccessor().setUserObject(lows);
        this.getHighAccessor().setUserObject(highs);
        this.setOrdinates(this.getLocalizationGridAccessor().appendChild(), values);
    }

    public double[] getOffsetVector(int dimension) {
        if (this.cells == null) {
            return new double[0];
        }
        this.cells.selectChild(dimension);
        return (double[])this.getCellsAccessor().getUserObject();
    }

    public void setOffsetVector(int dimension, double[] values) {
        MetadataAccessor cells = this.getCellsAccessor();
        cells.selectChild(dimension);
        cells.setUserObject(values);
    }

    public void addOffsetVector(double[] values) {
        this.setOffsetVector(this.getCellsAccessor().appendChild(), values);
    }

    public String getPixelOrientation() {
        return this.pixelOrientation != null ? this.pixelOrientation.getUserObject(String.class) : null;
    }

    public void setPixelOrientation(String pixelOrientation) {
        if (GeographicMetadataFormat.PIXEL_ORIENTATIONS.contains(pixelOrientation)) {
            this.getPixelOrientationAccessor().setUserObject(pixelOrientation);
        } else {
            this.warning("setPixelOrientation", 11, pixelOrientation);
        }
    }

    private MetadataAccessor getCellsAccessor() {
        if (this.cells == null) {
            this.cells = new MetadataAccessor(this.metadata, "rectifiedGridDomain/cells", "offsetVector");
        }
        return this.cells;
    }

    private MetadataAccessor getHighAccessor() {
        if (this.high == null) {
            this.high = new MetadataAccessor(this.metadata, "rectifiedGridDomain/limits/high", null);
        }
        return this.high;
    }

    private MetadataAccessor getLocalizationGridAccessor() {
        if (this.localizationGrid == null) {
            this.localizationGrid = new MetadataAccessor(this.metadata, "rectifiedGridDomain/localizationGrid", "ordinates");
        }
        return this.localizationGrid;
    }

    private MetadataAccessor getLowAccessor() {
        if (this.low == null) {
            this.low = new MetadataAccessor(this.metadata, "rectifiedGridDomain/limits/low", null);
        }
        return this.low;
    }

    private MetadataAccessor getLowerCornerAccessor() {
        if (this.lowerCorner == null) {
            this.lowerCorner = new MetadataAccessor(this.metadata, "boundedBy/lowerCorner", null);
        }
        return this.lowerCorner;
    }

    private MetadataAccessor getPixelOrientationAccessor() {
        if (this.pixelOrientation == null) {
            this.pixelOrientation = new MetadataAccessor(this.metadata, "rectifiedGridDomain/pixelOrientation", null);
        }
        return this.pixelOrientation;
    }

    private MetadataAccessor getUpperCornerAccessor() {
        if (this.upperCorner == null) {
            this.upperCorner = new MetadataAccessor(this.metadata, "boundedBy/upperCorner", null);
        }
        return this.upperCorner;
    }
}

