/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.image.io.mosaic.GridTileIterator;
import org.geotools.image.io.mosaic.OverviewLevel;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.util.FrequencySortedSet;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GridTileManager
extends TileManager {
    private static final long serialVersionUID = -3140767174475649400L;
    private final OverviewLevel root;
    private final Rectangle region;
    private final int count;
    private transient Collection<Tile> tiles;

    GridTileManager(OverviewLevel root) {
        this.root = root;
        this.region = new Rectangle(-1, -1);
        int count = 0;
        OverviewLevel level = root;
        do {
            this.region.add(level.getAbsoluteRegion());
            count += level.getNumTiles();
        } while ((level = level.getFinerLevel()) != null);
        this.count = count;
    }

    protected GridTileManager(Tile[] tiles) throws IOException, IllegalArgumentException {
        Object level;
        Tile.ensureNonNull("tiles", tiles);
        Tile[] modifiedOrder = tiles;
        HashMap<Dimension, Object> levelsBySubsampling = new HashMap<Dimension, Object>();
        for (int i = 0; i < modifiedOrder.length; ++i) {
            Tile tile = modifiedOrder[i];
            Dimension subsampling = tile.getSubsampling();
            level = (OverviewLevel)levelsBySubsampling.get(subsampling);
            if (level == null) {
                int j = i;
                while (++j < modifiedOrder.length) {
                    Tile candidate = modifiedOrder[j];
                    if (!candidate.isLargerThan(tile)) continue;
                    if (modifiedOrder == tiles) {
                        modifiedOrder = (Tile[])modifiedOrder.clone();
                    }
                    modifiedOrder[j] = tile;
                    tile = candidate;
                    subsampling = tile.getSubsampling();
                }
                level = new OverviewLevel(tile, subsampling);
                levelsBySubsampling.put(subsampling, level);
                continue;
            }
            ((OverviewLevel)level).add(tile, subsampling);
        }
        Object[] levels = levelsBySubsampling.values().toArray(new OverviewLevel[levelsBySubsampling.size()]);
        Arrays.sort(levels);
        this.region = new Rectangle(-1, -1);
        int count = 0;
        for (int i = 0; i < levels.length; ++i) {
            level = levels[i];
            ((OverviewLevel)level).createLinkedList(i, (OverviewLevel)(i != 0 ? levels[i - 1] : null));
            this.region.add(((OverviewLevel)level).getAbsoluteRegion());
            count += ((OverviewLevel)level).getNumTiles();
        }
        this.count = count;
        this.root = levels.length != 0 ? levels[levels.length - 1] : null;
    }

    @Override
    final Rectangle getRegion() {
        return this.region;
    }

    @Override
    final Dimension getTileSize() {
        for (OverviewLevel level = this.root; level != null; level = level.getFinerLevel()) {
            Dimension size = level.getTileSize();
            if (size == null) continue;
            return size;
        }
        return this.region.getSize();
    }

    @Override
    final boolean isImageTiled() throws IOException {
        return this.count >= 2;
    }

    @Override
    final Collection<Tile> getInternalTiles() {
        FrequencySortedSet tiles = new FrequencySortedSet();
        for (OverviewLevel level = this.root; level != null; level = level.getFinerLevel()) {
            level.getInternalTiles((FrequencySortedSet<? super Tile>)tiles);
        }
        return tiles;
    }

    @Override
    public synchronized Collection<Tile> getTiles() {
        if (this.tiles == null) {
            this.tiles = new AbstractSet<Tile>(){

                @Override
                public int size() {
                    return GridTileManager.this.count;
                }

                @Override
                public Iterator<Tile> iterator() {
                    return new GridTileIterator(GridTileManager.this.root);
                }

                @Override
                public boolean contains(Object object) {
                    return object instanceof Tile && OverviewLevel.contains(GridTileManager.this.root, (Tile)object);
                }
            };
        }
        return this.tiles;
    }

    @Override
    public Collection<Tile> getTiles(Rectangle region, Dimension subsampling, boolean subsamplingChangeAllowed) throws IOException {
        for (OverviewLevel level = this.root; level != null; level = level.getFinerLevel()) {
            Tile sample = level.getSampleTile();
            Dimension doable = sample.getSubsamplingFloor(subsampling);
            if (doable == null || doable != subsampling && !subsamplingChangeAllowed) continue;
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            level.getTiles(tiles, region, subsampling, Long.MAX_VALUE);
            subsampling.setSize(doable);
            return tiles;
        }
        return null;
    }

    @Override
    public boolean intersects(Rectangle region, Dimension subsampling) throws IOException {
        for (OverviewLevel level = this.root; level != null; level = level.getFinerLevel()) {
            int c = level.compareTo(subsampling);
            if (c > 0 || !level.intersects(region)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 0x332BEE88 ^ this.root.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GridTileManager that = (GridTileManager)object;
            return this.count == that.count && Utilities.equals((Object)this.region, (Object)that.region) && Utilities.equals((Object)this.root, (Object)that.root);
        }
        return false;
    }
}

