/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.image.io.mosaic.Tile;

public class LargeTile
extends Tile {
    private static final long serialVersionUID = -390809968753673788L;
    private int width;
    private int height;

    public LargeTile(ImageReaderSpi provider, Object input, int imageIndex, Point location, Dimension subsampling) throws IllegalArgumentException {
        super(provider, input, imageIndex, location, subsampling);
    }

    public LargeTile(ImageReaderSpi provider, Object input, int imageIndex, Rectangle region, Dimension subsampling) throws IllegalArgumentException {
        super(provider, input, imageIndex, region, subsampling);
    }

    public LargeTile(ImageReaderSpi provider, Object input, int imageIndex, Rectangle region, AffineTransform gridToCRS) throws IllegalArgumentException {
        super(provider, input, imageIndex, region, gridToCRS);
        try {
            assert (region == null || region.equals(this.getRegion()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public LargeTile(ImageReaderSpi provider, Object input, int imageIndex, Rectangle region) throws IllegalArgumentException {
        super(provider, input, imageIndex, region);
        try {
            assert (region.equals(this.getRegion()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    final void setSize(int dx, int dy) throws IllegalArgumentException {
        super.setSize(Math.min(dx, 65535), Math.min(dy, 65535));
        this.width = dx;
        this.height = dy;
    }

    public Rectangle getRegion() throws IOException {
        Rectangle region = super.getRegion();
        region.width = this.width;
        region.height = this.height;
        return region;
    }
}

