/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.util.Map;
import javax.imageio.IIOParam;
import javax.imageio.IIOParamController;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.geotools.image.io.mosaic.MosaicImageReadParam;
import org.geotools.image.io.mosaic.Tile;

public class MosaicController
implements IIOParamController {
    static final MosaicController DEFAULT = new MosaicController();

    protected MosaicController() {
    }

    public boolean activate(IIOParam parameters) {
        if (parameters instanceof MosaicImageReadParam) {
            MosaicImageReadParam params = (MosaicImageReadParam)parameters;
            for (Map.Entry<ImageReader, ImageReadParam> entry : params.readers.entrySet()) {
                ImageReadParam p = entry.getValue();
                if (p == null) {
                    p = params.getTileParameters(entry.getKey());
                    entry.setValue(p);
                }
                if (this.activateForTile(p)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean activateForTile(IIOParam parameters) {
        if (parameters.hasController()) {
            return parameters.activateController();
        }
        return true;
    }

    protected void configure(Tile tile, IIOParam parameters) {
    }
}

