/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: DiamondShapeCreator.java
 * created: Nov 4, 2009
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;

/**
 * ShapeCreator for diamond shapes
 * @author fabiomano
 */
public class DiamondShapeCreator extends AbstractShapeCreator
{
    private static final String SHAPE_NAME = "diamond";
    
    /* (non-Javadoc)
     * @see org.geotools.renderer.style.customshape.AbstractShapeCreator#createShape(org.geotools.renderer.style.customshape.AbstractShapeCreator.Parameter<java.lang.String>[])
     */
    @Override
    protected Shape createShape(Parameter<String>... parameters)
    {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0);
        gp.lineTo(0, -0.5f);
        gp.lineTo(0.5f, 0);
        gp.lineTo(0, 0.5f);
        gp.lineTo(-0.5f, 0);
        gp.closePath();
        
        return gp;
    }

    /* (non-Javadoc)
     * @see org.geotools.renderer.style.customshape.ShapeCreator#getShapeName()
     */
    @Override
    public String getShapeName()
    {
        return SHAPE_NAME;
    }

    public String buildShapeSpecification()
    {
        return getShapeName();
    }      
}
