package org.geotools.renderer.style.customshape;

import java.awt.Shape;

/**
 * This interface represents a shape factory that creates a shape based on a string that specifies 
 * the shape build parameters.
 * @author fmoura
 *
 */
public interface ShapeCreator {

	/**
	 * Gets this shape name
	 * @return
	 */
	public String getShapeName();
	
	/**
	 * Creates the shape based on a specification string.
	 * @param shapeSpecification The String that specifies the build parameters for creating a shape instance. 
	 * @return The shape instance created. Return null if the shapeSpecification is null or malformed. 
	 *  
	 */
	public Shape createShape(String shapeSpecification);

}
