/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;
import org.geotools.renderer.style.customshape.AbstractShapeCreator;

public class RectangleShapeCreator
extends AbstractShapeCreator {
    private static final String SHAPE_NAME = "rectangle";
    private static final String ASPECT_PARAMETER_NAME = "aspect";
    private static Logger _logger = Logger.getLogger(RectangleShapeCreator.class);

    @Override
    protected Shape createShape(AbstractShapeCreator.Parameter<String> ... parameters) {
        String aspectStr = null;
        for (AbstractShapeCreator.Parameter<String> parameter : parameters) {
            if (!parameter.getName().equalsIgnoreCase(ASPECT_PARAMETER_NAME)) continue;
            aspectStr = parameter.getValue();
        }
        if (aspectStr == null) {
            _logger.warn((Object)"Missing required param 'aspect'");
            return null;
        }
        double aspect = 0.0;
        try {
            aspect = Double.parseDouble(aspectStr);
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)"Parameter 'aspect' in invalid format", (Throwable)e);
            return null;
        }
        return this.createShape(aspect);
    }

    public Shape createShape(double aspect) {
        aspect = Math.abs(aspect);
        return new Rectangle2D.Double(-aspect / 2.0, -0.5, aspect, 1.0);
    }

    @Override
    public String getShapeName() {
        return SHAPE_NAME;
    }

    public String buildShapeSpecification(double aspect) {
        AbstractShapeCreator.Parameter<String> aspectParameter = new AbstractShapeCreator.Parameter<String>(ASPECT_PARAMETER_NAME, String.valueOf(aspect));
        return this.buildShapeSpecification(aspectParameter);
    }
}

