/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 * 
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *    
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.Line2D;

/**
 * ShapeCreator for a horizontal line.
 * 
 * @author milton
 */
public class HorizontalLineShapeCreator extends AbstractShapeCreator
{
    public String getShapeName()
    {
        return "horline";
    }

    public Shape createShape(Parameter<String>... parameters)
    {
        return new Line2D.Double(-0.5, 0, 0.5, 0);
    }

    public String buildShapeSpecification()
    {
        return getShapeName();
    }
}
