/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2CoordinateSystem {
    private int srsId;
    private String coordsysName;
    private CoordinateReferenceSystem crs = null;
    private String organization;
    private int coordsysId;
    private String definition;

    public DB2CoordinateSystem(Connection conn, int srsId) throws SQLException {
        this.srsId = srsId;
        this.loadFromDB(conn);
    }

    private void loadFromDB(Connection conn) throws SQLException {
        String querySRS = "SELECT coordsys_name, organization, organization_coordsys_id,  definition FROM db2gse.st_spatial_reference_systems WHERE srs_id = " + this.srsId;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(querySRS);
        if (!rs.next()) {
            throw new SQLException("Unrecognized srid '" + this.srsId + "'");
        }
        this.coordsysName = rs.getString(1);
        this.organization = rs.getString(2);
        this.coordsysId = rs.getInt(3);
        this.definition = rs.getString(4);
        rs.close();
        stmt.close();
    }

    public String toString() {
        return this.coordsysName + "=" + this.organization + ":" + this.coordsysId;
    }

    int getCsId() {
        return this.coordsysId;
    }

    CoordinateReferenceSystem getCRS() throws FactoryRegistryException, FactoryException {
        if (this.crs == null) {
            this.crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(this.definition);
        }
        return this.crs;
    }
}

