/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geotools.referencing.factory.epsg.SqlScriptReader;
import org.h2.jdbcx.JdbcDataSource;

public class DatabaseCreationScript {
    public static void main(String[] args) throws Exception {
        File[] files;
        String inputDirectory = "/home/aaime/devel/gt2.6.x/modules/unsupported/epsg-h2/src/main/resources/org/geotools/referencing/factory/epsg/";
        File directory = new File(inputDirectory);
        File databaseFile = new File(directory, "EPSG.data.db");
        File indexFile = new File(directory, "EPSG.index.db");
        File lobDirectory = new File(directory, "EPSG.lobs.db");
        File zipFile = new File(directory, "EPSG.zip");
        indexFile.delete();
        databaseFile.delete();
        zipFile.delete();
        JdbcDataSource source = new JdbcDataSource();
        StringBuilder url = new StringBuilder("jdbc:h2:");
        String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
        if (path.length() == 0 || path.charAt(0) != '/') {
            url.append('/');
        }
        url.append(path);
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        url.append("EPSG");
        url.append(";AUTO_RECONNECT=TRUE;CACHE_SIZE=131072;CACHE_TYPE=TQ");
        source.setURL(url.toString());
        source.setUser("sa");
        source.setPassword("");
        Connection connection = source.getConnection();
        System.out.println("Creating the EPSG database");
        Statement statement = connection.createStatement();
        try {
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_Tables_PostgreSQL.sql"), statement);
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_Data_PostgreSQL.sql"), statement);
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_FKeys_PostgreSQL.sql"), statement);
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_Indexes_H2.sql"), statement);
            statement.execute("SHUTDOWN COMPACT");
        }
        catch (IOException exception) {
            SQLException e = new SQLException("Error occurred while executing the EPSG database creation scripts");
            e.initCause(exception);
            throw e;
        }
        finally {
            statement.close();
            connection.close();
        }
        System.out.println("EPSG database created");
        System.out.println("Creating the zipped database");
        byte[] buf = new byte[1024];
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        for (File file : files = new File[]{databaseFile, indexFile}) {
            int len;
            FileInputStream in = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(file.getName()));
            while ((len = in.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        }
        zos.close();
        System.out.println("Cleaning up the unzipped database files");
        databaseFile.delete();
        indexFile.delete();
        System.out.println("Done. The zipped database file is available at " + zipFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeScript(File scriptFile, Statement statement) throws IOException, SQLException {
        System.out.println("Executing script " + scriptFile.getPath());
        SqlScriptReader reader = null;
        try {
            reader = new SqlScriptReader(new InputStreamReader((InputStream)new FileInputStream(scriptFile), "ISO-8859-15"));
            while (reader.hasNext()) {
                statement.execute(reader.next());
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }
}

