/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.epsg.AnsiDialectEpsgFactory;

public class OracleDialectEpsgFactory
extends AnsiDialectEpsgFactory {
    private final Pattern pattern = Pattern.compile("\\sAS\\s");

    public OracleDialectEpsgFactory(Hints userHints, Connection connection) {
        super(userHints, connection);
    }

    public OracleDialectEpsgFactory(Hints userHints, DataSource datasource) {
        super(userHints, datasource);
    }

    public OracleDialectEpsgFactory(Hints userHints, Connection connection, String epsgSchema) {
        super(userHints, connection);
        this.adaptTableNames(epsgSchema);
    }

    protected String adaptSQL(String statement) {
        return this.pattern.matcher(super.adaptSQL(statement)).replaceAll(" ");
    }

    private void adaptTableNames(String epsgSchema) {
        if (epsgSchema != null && (epsgSchema = epsgSchema.trim()).length() != 0) {
            for (Map.Entry entry : this.map.entrySet()) {
                String tableName = (String)entry.getValue();
                if (!tableName.startsWith("epsg_")) continue;
                entry.setValue(String.valueOf(epsgSchema) + '.' + tableName);
            }
        }
    }
}

