/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverageWriter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.grid.io.imageio.geotiff.CRS2GeoTiffMetadataAdapter;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataEncoder;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.image.io.GridCoverageWriterProgressAdapter;
import org.geotools.image.io.ImageIOExt;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Vocabulary;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.util.ProgressListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeoTiffWriter
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private final Map<String, String> metadataKeyValue = new HashMap<String, String>();
    private static final TIFFImageWriterSpi tiffWriterFactory = new TIFFImageWriterSpi();

    public GeoTiffWriter(Object destination) throws IOException {
        this(destination, null);
    }

    public void setMetadataValue(String name, String value) throws IOException {
        if (name != null && name.length() > 0) {
            this.metadataKeyValue.put(name, value);
        }
    }

    public GeoTiffWriter(Object destination, Hints hints) throws IOException {
        this.destination = destination;
        if (destination instanceof File) {
            this.outStream = ImageIOExt.createImageOutputStream(null, (Object)destination);
        } else if (destination instanceof URL) {
            URL dest = (URL)destination;
            if (dest.getProtocol().equalsIgnoreCase("file")) {
                File destFile = DataUtilities.urlToFile((URL)dest);
                this.outStream = ImageIOExt.createImageOutputStream(null, (Object)destFile);
            }
        } else if (destination instanceof OutputStream) {
            this.outStream = ImageIOExt.createImageOutputStream(null, (Object)((OutputStream)destination));
        } else if (destination instanceof ImageOutputStream) {
            this.outStream = (ImageOutputStream)destination;
        } else {
            throw new IllegalArgumentException("The provided destination canno be used!");
        }
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            hints.remove((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
            this.hints.add((RenderingHints)hints);
            this.hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        }
    }

    public Format getFormat() {
        return new GeoTiffFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(GridCoverage gc, GeneralParameterValue[] params) throws IllegalArgumentException, IOException, IndexOutOfBoundsException {
        GeoTiffWriteParams gtParams = null;
        boolean writeTfw = (Boolean)GeoTiffFormat.WRITE_TFW.getDefaultValue();
        ProgressListener listener = null;
        if (params != null && params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                Parameter param = (Parameter)params[i];
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (name.equals(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName())) {
                    gtParams = (GeoToolsWriteParams)param.getValue();
                    continue;
                }
                if (name.equals(GeoTiffFormat.WRITE_TFW.getName())) {
                    writeTfw = (Boolean)param.getValue();
                    continue;
                }
                if (!name.equals(GeoTiffFormat.PROGRESS_LISTENER.getName())) continue;
                listener = (ProgressListener)param.getValue();
            }
        }
        if (gtParams == null) {
            gtParams = new GeoTiffWriteParams();
        }
        GridGeometry2D gg = (GridGeometry2D)gc.getGridGeometry();
        GridEnvelope2D range = gg.getGridRange2D();
        Rectangle sourceRegion = gtParams.getSourceRegion();
        if (sourceRegion != null) {
            range = new GridEnvelope2D(sourceRegion);
        }
        AffineTransform tr = (AffineTransform)gg.getGridToCRS2D();
        CoordinateReferenceSystem crs = gg.getCoordinateReferenceSystem2D();
        double inNoData = GeoTiffWriter.getCandidateNoData(gc);
        if (crs instanceof ProjectedCRS || crs instanceof GeographicCRS) {
            CRS2GeoTiffMetadataAdapter adapter = new CRS2GeoTiffMetadataAdapter(crs);
            GeoTiffIIOMetadataEncoder metadata = adapter.parseCoordinateReferenceSystem();
            if (!Double.isNaN(inNoData)) {
                metadata.setNoData(inNoData);
            }
            if (this.metadataKeyValue != null && !this.metadataKeyValue.isEmpty()) {
                metadata.setTiffTagsMetadata(this.metadataKeyValue);
            }
            GeoTiffWriter.setGeoReference(crs, metadata, tr, range);
            this.writeImage(((GridCoverage2D)gc).geophysics(true).getRenderedImage(), this.outStream, metadata, gtParams, listener);
            if (writeTfw && this.destination instanceof File) {
                File destFile = (File)this.destination;
                File tfw = new File(destFile.getParentFile(), destFile.getName().replace("tif", "tfw"));
                BufferedWriter outW = new BufferedWriter(new FileWriter(tfw));
                try {
                    outW.write(gc.getCoordinateReferenceSystem().toWKT());
                }
                finally {
                    try {
                        outW.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            throw new GeoTiffException(null, "The supplied grid coverage uses an unsupported crs! You are allowed to use only projected and geographic coordinate reference systems", null);
        }
    }

    private static void setGeoReference(CoordinateReferenceSystem crs, GeoTiffIIOMetadataEncoder metadata, AffineTransform rasterToModel, GridEnvelope2D range) throws IndexOutOfBoundsException, IOException {
        AffineTransform modifiedRasterToModel = new AffineTransform(rasterToModel);
        modifiedRasterToModel.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        int minx = range.getLow(0);
        int miny = range.getLow(1);
        if (minx != 0 || miny != 0) {
            modifiedRasterToModel.concatenate(AffineTransform.getTranslateInstance(minx, miny));
        }
        metadata.addGeoShortParam(1025, 1);
        boolean lonFirst = XAffineTransform.getSwapXY((AffineTransform)modifiedRasterToModel) != -1;
        double rotation = XAffineTransform.getRotation((AffineTransform)modifiedRasterToModel);
        if (!(Double.isInfinite(rotation) || Double.isNaN(rotation) || Math.abs(rotation) > 1.0E-6)) {
            double tiePointLongitude = lonFirst ? modifiedRasterToModel.getTranslateX() : modifiedRasterToModel.getTranslateY();
            double tiePointLatitude = lonFirst ? modifiedRasterToModel.getTranslateY() : modifiedRasterToModel.getTranslateX();
            metadata.setModelTiePoint(0.0, 0.0, 0.0, tiePointLongitude, tiePointLatitude, 0.0);
            double scaleModelToRasterLongitude = lonFirst ? Math.abs(modifiedRasterToModel.getScaleX()) : Math.abs(modifiedRasterToModel.getShearY());
            double scaleModelToRasterLatitude = lonFirst ? Math.abs(modifiedRasterToModel.getScaleY()) : Math.abs(modifiedRasterToModel.getShearX());
            metadata.setModelPixelScale(scaleModelToRasterLongitude, scaleModelToRasterLatitude, 0.0);
        } else {
            metadata.setModelTransformation(modifiedRasterToModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeImage(RenderedImage image, ImageOutputStream outputStream, GeoTiffIIOMetadataEncoder geoTIFFMetadata, GeoToolsWriteParams gtParams, ProgressListener listener) throws IOException {
        if (image == null || outputStream == null) {
            throw new NullPointerException("Some input parameters are null");
        }
        ImageWriteParam params = gtParams.getAdaptee();
        ImageWriter writer = tiffWriterFactory.createWriterInstance();
        IIOMetadata metadata = GeoTiffWriter.createGeoTiffIIOMetadata(writer, ImageTypeSpecifier.createFromRenderedImage(image), geoTIFFMetadata, params);
        try {
            writer.setOutput(outputStream);
            if (listener != null) {
                GridCoverageWriterProgressAdapter progressAdapter = new GridCoverageWriterProgressAdapter(listener);
                writer.addIIOWriteProgressListener((IIOWriteProgressListener)progressAdapter);
                writer.addIIOWriteWarningListener((IIOWriteWarningListener)progressAdapter);
            }
            writer.write(writer.getDefaultStreamMetadata(params), new IIOImage(image, null, metadata), params);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                }
            }
            catch (Throwable e) {}
            try {
                if (!(this.destination instanceof ImageOutputStream) && outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (writer != null) {
                    writer.dispose();
                }
            }
            catch (Throwable e) {}
        }
        return true;
    }

    public static final IIOMetadata createGeoTiffIIOMetadata(ImageWriter writer, ImageTypeSpecifier type, GeoTiffIIOMetadataEncoder geoTIFFMetadata, ImageWriteParam params) throws IIOException {
        IIOMetadata imageMetadata = writer.getDefaultImageMetadata(type, params);
        imageMetadata = writer.convertImageMetadata(imageMetadata, type, params);
        Element w3cElement = (Element)imageMetadata.getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        org.jdom.Element element = new DOMBuilder().build(w3cElement);
        geoTIFFMetadata.assignTo(element);
        Parent parent = element.getParent();
        parent.removeContent((Content)element);
        Document document = new Document(element);
        try {
            org.w3c.dom.Document w3cDoc = new DOMOutputter().output(document);
            TIFFImageMetadata iioMetadata = new TIFFImageMetadata(TIFFImageMetadata.parseIFD((Node)w3cDoc.getDocumentElement().getFirstChild()));
            imageMetadata = iioMetadata;
        }
        catch (JDOMException e) {
            throw new IIOException("Failed to set GeoTIFFWritingUtilities specific tags.", e);
        }
        catch (IIOInvalidTreeException e) {
            throw new IIOException("Failed to set GeoTIFFWritingUtilities specific tags.", e);
        }
        return imageMetadata;
    }

    static double getCandidateNoData(GridCoverage gc) {
        GridSampleDimension sd = (GridSampleDimension)gc.getSampleDimension(0);
        List categories = sd.getCategories();
        double inNoData = Double.NaN;
        if (categories != null) {
            String noDataName = Vocabulary.format((int)147);
            for (Category category : categories) {
                Category candidate = category;
                String name = candidate.getName().toString();
                if (!name.equalsIgnoreCase("No Data") && !name.equalsIgnoreCase(noDataName)) continue;
                inNoData = candidate.getRange().getMaximum();
                break;
            }
        }
        return inNoData;
    }
}

