/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SwingUtil {
    public static ListModel toListModel(final List elements) {
        return new AbstractListModel(){

            public int getSize() {
                return elements.size();
            }

            public Object getElementAt(int index) {
                return elements.get(index);
            }
        };
    }

    public static ListModel toListModel(Collection elements) {
        return SwingUtil.toListModel(new ArrayList(elements));
    }

    public static List toList(ListModel model) {
        ArrayList list = new ArrayList(model.getSize());
        int i = 0;
        while (i < model.getSize()) {
            list.add(model.getElementAt(i));
            ++i;
        }
        return list;
    }

    public static void setSelection(JList list, Object element) {
        int i = 0;
        while (i < list.getModel().getSize()) {
            Object value = list.getModel().getElementAt(i);
            if (value == element) {
                list.setSelectedIndex(i);
                list.scrollRectToVisible(list.getCellBounds(i, i));
                return;
            }
            ++i;
        }
    }

    public static void addDoubleClickEvent(JList list) {
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JList source = (JList)e.getSource();
                if (e.getClickCount() == 2) {
                    ListSelectionListener[] listeners = source.getListSelectionListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].valueChanged(new ListSelectionEvent(source, source.getSelectedIndex(), source.getSelectedIndex(), false));
                        ++i;
                    }
                }
            }
        });
    }
}

