/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.geotools.graph.util.StringUtil;

public class ZipUtil {
    public static void zip(String zipFilename, String[] filenames) throws IOException {
        ZipUtil.zip(zipFilename, filenames, filenames);
    }

    public static void zip(String zipFilename, String[] filenames, String[] archFilenames) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFilename)));
        byte[] data = new byte[512];
        int i = 0;
        while (i < filenames.length) {
            int bc;
            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(filenames[i]));
            ZipEntry entry = new ZipEntry(StringUtil.stripPath(archFilenames[i]));
            zout.putNextEntry(entry);
            while ((bc = ((InputStream)fin).read(data, 0, 512)) != -1) {
                zout.write(data, 0, bc);
            }
            zout.flush();
            ++i;
        }
        zout.close();
    }

    public static void unzip(String zipFilename, Collection filenames, String outdir) throws IOException {
        ZipUtil.unzip(zipFilename, filenames.toArray(new String[filenames.size()]), outdir);
    }

    public static void unzip(String zipFilename, String[] filenames, String outdir) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilename);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        block0: while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            int i = 0;
            while (i < filenames.length) {
                if (entry.getName().equals(filenames[i])) {
                    int len;
                    byte[] buffer = new byte[1024];
                    InputStream zipin = zipFile.getInputStream(entry);
                    BufferedOutputStream fileout = new BufferedOutputStream(new FileOutputStream(String.valueOf(outdir) + "\\" + filenames[i]));
                    while ((len = zipin.read(buffer)) >= 0) {
                        fileout.write(buffer, 0, len);
                    }
                    zipin.close();
                    fileout.flush();
                    fileout.close();
                    continue block0;
                }
                ++i;
            }
        }
    }

    public static void unzip(String zipFilename, String outdir) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilename);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            byte[] buffer = new byte[1024];
            InputStream zipin = zipFile.getInputStream(entry);
            BufferedOutputStream fileout = new BufferedOutputStream(new FileOutputStream(String.valueOf(outdir) + "\\" + entry.getName()));
            while ((len = zipin.read(buffer)) >= 0) {
                fileout.write(buffer, 0, len);
            }
            zipin.close();
            fileout.flush();
            fileout.close();
        }
    }
}

