/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.Collection;

public class GeometryUtil {
    private static GeometryFactory geomFactory;
    private static PrecisionModel precModel;

    public static boolean isEqual(Coordinate[] c1, Coordinate[] c2) {
        return GeometryUtil.isEqual(c1, c2, false);
    }

    public static boolean isEqual(Coordinate[] c1, Coordinate[] c2, boolean reverse) {
        if (c1.length != c2.length) {
            return false;
        }
        if (!reverse) {
            int i = 0;
            while (i < c1.length) {
                if (!c1[i].equals((Object)c2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < c1.length) {
            if (!c1[i].equals((Object)c2[c1.length - i - 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static LineString joinLinestrings(LineString l1, LineString l2) {
        Coordinate[] merged = new Coordinate[l1.getNumPoints() + l2.getNumPoints() - 1];
        if (l1.getCoordinateN(l1.getNumPoints() - 1).equals((Object)l2.getCoordinateN(0))) {
            int i = 0;
            while (i < l1.getNumPoints()) {
                merged[i] = l1.getCoordinateN(i);
                ++i;
            }
            i = 0;
            while (i < l2.getNumPoints() - 1) {
                merged[i + l1.getNumPoints()] = l2.getCoordinateN(i + 1);
                ++i;
            }
        } else if (l2.getCoordinateN(l2.getNumPoints() - 1).equals((Object)l1.getCoordinateN(0))) {
            int i = 0;
            while (i < l2.getNumPoints()) {
                merged[i] = l2.getCoordinateN(i);
                ++i;
            }
            i = 0;
            while (i < l1.getNumPoints() - 1) {
                merged[i + l2.getNumPoints()] = l1.getCoordinateN(i + 1);
                ++i;
            }
        } else if (l1.getCoordinateN(l1.getNumPoints() - 1).equals((Object)l2.getCoordinateN(l2.getNumPoints() - 1))) {
            int i = 0;
            while (i < l1.getNumPoints()) {
                merged[i] = l1.getCoordinateN(i);
                ++i;
            }
            i = 0;
            while (i < l2.getNumPoints() - 1) {
                merged[i + l1.getNumPoints()] = l2.getCoordinateN(l2.getNumPoints() - 2 - i);
                ++i;
            }
        } else if (l1.getCoordinateN(0).equals((Object)l2.getCoordinateN(0))) {
            int i = 0;
            while (i < l2.getNumPoints()) {
                merged[i] = l2.getCoordinateN(l2.getNumPoints() - 1 - i);
                ++i;
            }
            i = 0;
            while (i < l1.getNumPoints() - 1) {
                merged[i + l2.getNumPoints()] = l1.getCoordinateN(i + 1);
                ++i;
            }
        } else {
            return null;
        }
        return GeometryUtil.gf().createLineString(merged);
    }

    public static double angleBetween(LineSegment l1, LineSegment l2, double tol) {
        double s1 = (l1.p1.y - l1.p0.y) / (l1.p1.x - l1.p0.x);
        double s2 = (l2.p1.y - l2.p0.y) / (l2.p1.x - l2.p0.x);
        if (Math.abs(s1 - s2) < tol) {
            return 0.0;
        }
        if (Math.abs(s1 + s2) < tol) {
            return Math.PI;
        }
        LineSegment tls1 = new LineSegment(new Coordinate(0.0, 0.0), new Coordinate(l1.p1.x - l1.p0.x, l1.p1.y - l1.p0.y));
        LineSegment tls2 = new LineSegment(new Coordinate(0.0, 0.0), new Coordinate(l2.p1.x - l2.p0.x, l2.p1.y - l2.p0.y));
        LineSegment ls3 = new LineSegment(tls1.p1, tls2.p1);
        double c = ls3.getLength();
        double a = tls1.getLength();
        double b = tls2.getLength();
        return Math.acos((a * a + b * b - c * c) / (2.0 * a * b));
    }

    public static double angleBetween(LineString l1, LineString l2, double tol) {
        LineSegment ls1 = new LineSegment(l1.getCoordinateN(l1.getNumPoints() - 2), l1.getCoordinateN(l1.getNumPoints() - 1));
        LineSegment ls2 = new LineSegment(l2.getCoordinateN(0), l2.getCoordinateN(1));
        return GeometryUtil.angleBetween(ls1, ls2, tol);
    }

    public static double dx(LineString ls) {
        return ls.getPointN(ls.getNumPoints() - 1).getX() - ls.getPointN(0).getX();
    }

    public static double dy(LineString ls) {
        return ls.getPointN(ls.getNumPoints() - 1).getY() - ls.getPointN(0).getY();
    }

    public static Geometry reverseGeometry(Geometry geom, boolean modify) {
        if (geom instanceof Point) {
            return geom;
        }
        if (geom instanceof LineString) {
            Coordinate[] reversed = GeometryUtil.reverseCoordinates(geom.getCoordinates(), modify);
            if (modify) {
                return geom;
            }
            return GeometryUtil.gf().createLineString(reversed);
        }
        return null;
    }

    public static Coordinate[] reverseCoordinates(Coordinate[] c, boolean modify) {
        if (modify) {
            int n = c.length / 2;
            int i = 0;
            while (i < n) {
                Coordinate tmp = c[i];
                c[i] = c[c.length - 1 - i];
                c[c.length - 1 - i] = tmp;
                ++i;
            }
            return c;
        }
        Coordinate[] cnew = new Coordinate[c.length];
        int i = 0;
        while (i < c.length) {
            cnew[i] = c[c.length - 1 - i];
            ++i;
        }
        return cnew;
    }

    public static double averageDistance(LineString to, Collection from) {
        double avg = 0.0;
        int n = 0;
        for (LineString ls : from) {
            n += ls.getNumPoints();
            int i = 0;
            while (i < ls.getNumPoints()) {
                avg += ls.getPointN(i).distance((Geometry)to);
                ++i;
            }
        }
        return avg / (double)n;
    }

    public static LineString simplifyLineString(LineString line) {
        double x = 0.0;
        double y = 0.0;
        int n = line.getNumPoints();
        int i = 0;
        while (i < n) {
            Coordinate c = line.getCoordinateN(i);
            x += c.x;
            y += c.y;
            ++i;
        }
        LineString simple = GeometryUtil.gf().createLineString(new Coordinate[]{line.getCoordinateN(0), new Coordinate(x /= (double)n, y /= (double)n), line.getCoordinateN(n - 1)});
        return simple;
    }

    public static PrecisionModel basicPrecisionModel() {
        return GeometryUtil.pm();
    }

    public static GeometryFactory gf() {
        if (geomFactory == null) {
            geomFactory = new GeometryFactory();
        }
        return geomFactory;
    }

    public static PrecisionModel pm() {
        if (precModel == null) {
            precModel = new PrecisionModel();
        }
        return precModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LineString normalizeLinestring(LineString line, double sample) {
        int j;
        Coordinate[] c = line.getCoordinates();
        boolean[] remove = new boolean[c.length];
        int nremove = 0;
        double[] add = new double[c.length];
        int nadd = 0;
        if (c.length == 2) {
            if (!(GeometryUtil.distance(c, 0, 1) > sample)) return line;
            int n = (int)(GeometryUtil.distance(c, 0, 1) / sample);
            if (n > 1) {
                nadd += n - 1;
                add[0] = GeometryUtil.distance(c, 0, 1) / (double)n;
            }
        } else {
            int n;
            int i = 0;
            while (i < c.length - 2) {
                j = i + 1;
                while (j < c.length - 1) {
                    if (!(GeometryUtil.distance(c, i, j) < sample)) break;
                    remove[j] = true;
                    ++nremove;
                    ++j;
                }
                if ((n = (int)(GeometryUtil.distance(c, i, j) / sample)) > 1) {
                    add[i] = GeometryUtil.distance(c, i, j) / (double)n;
                    nadd += n - 1;
                }
                i = j;
            }
            int k = c.length - 2;
            while (k >= 1) {
                if (!remove[k]) {
                    if (GeometryUtil.distance(c, c.length - 1, k) < sample) {
                        remove[k] = true;
                        ++nremove;
                        int l = k - 1;
                        while (l >= 0) {
                            if (!remove[l]) break;
                            --l;
                        }
                        if (l <= -1) break;
                        int n2 = (int)(GeometryUtil.distance(c, l, k) / sample);
                        if (n2 > 1) {
                            add[l] = 0.0;
                            nadd -= n2 - 1;
                        }
                        if ((n2 = (int)(GeometryUtil.distance(c, l, c.length - 1) / sample)) <= 1) break;
                        add[l] = GeometryUtil.distance(c, l, c.length - 1) / (double)n2;
                        nadd += n2 - 1;
                        break;
                    }
                    if (k != c.length - 2 || (n = (int)(GeometryUtil.distance(c, k, c.length - 1) / sample)) <= 1) break;
                    nadd += n - 1;
                    add[k] = GeometryUtil.distance(c, k, c.length - 1) / (double)n;
                    break;
                }
                --k;
            }
        }
        Coordinate[] newc = new Coordinate[c.length - nremove + nadd];
        j = 0;
        int i = 0;
        while (i < c.length) {
            if (!remove[i]) {
                newc[j++] = c[i];
                if (add[i] > 0.0) {
                    int next = -1;
                    int k = i + 1;
                    while (k < c.length && next == -1) {
                        if (!remove[k]) {
                            next = k;
                        }
                        ++k;
                    }
                    if (next != -1) {
                        double dx = (c[next].x - c[i].x) * add[i] / GeometryUtil.distance(c, i, next);
                        double dy = (c[next].y - c[i].y) * add[i] / GeometryUtil.distance(c, i, next);
                        int n = (int)(GeometryUtil.distance(c, i, next) / add[i] + 1.0E-6);
                        int k2 = 1;
                        while (k2 < n) {
                            newc[j++] = new Coordinate(c[i].x + (double)k2 * dx, c[i].y + (double)k2 * dy);
                            ++k2;
                        }
                    }
                }
            }
            ++i;
        }
        return GeometryUtil.gf().createLineString(newc);
    }

    public static double distance(Coordinate[] c, int i, int j) {
        if (i > j) {
            int tmp = i;
            i = j;
            j = tmp;
        }
        double dist = 0.0;
        int k = i;
        while (k < j) {
            dist += c[k].distance(c[k + 1]);
            ++k;
        }
        return dist;
    }
}

