/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.RenderedImageAdapter;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.processing.Operations;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageComposerThread;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.ImageMosaicJDBCFormat;
import org.geotools.gce.imagemosaic.jdbc.ImageMosaicJDBCReaderState;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccess;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.BufferedCoordinateOperationFactory;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMosaicJDBCReader
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicJDBCReader.class.getPackage().getName());
    protected static final CoordinateOperationFactory operationFactory = new BufferedCoordinateOperationFactory(new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    private final JDBCAccess jdbcAccess;
    private Config config;
    private static Set<AxisDirection> UPDirections;
    private static Set<AxisDirection> LEFTDirections;
    protected static int DEFAULT_IMAGE_TYPE;

    public ImageMosaicJDBCReader(Object source, Hints uHints) throws IOException, MalformedURLException {
        LEFTDirections = new HashSet<AxisDirection>();
        LEFTDirections.add(AxisDirection.DISPLAY_LEFT);
        LEFTDirections.add(AxisDirection.EAST);
        LEFTDirections.add(AxisDirection.GEOCENTRIC_X);
        LEFTDirections.add(AxisDirection.COLUMN_POSITIVE);
        UPDirections = new HashSet<AxisDirection>();
        UPDirections.add(AxisDirection.DISPLAY_UP);
        UPDirections.add(AxisDirection.NORTH);
        UPDirections.add(AxisDirection.GEOCENTRIC_Y);
        UPDirections.add(AxisDirection.ROW_POSITIVE);
        this.source = source;
        URL url = ImageMosaicJDBCFormat.getURLFromSource(source);
        if (url == null) {
            throw new MalformedURLException(source.toString());
        }
        try {
            this.config = Config.readFrom(url);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new IOException(e.getMessage());
        }
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageName = this.config.getCoverageName();
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        try {
            this.jdbcAccess = JDBCAccessFactory.getJDBCAcess(this.config);
        }
        catch (Exception e1) {
            LOGGER.severe(e1.getLocalizedMessage());
            throw new IOException(e1.getLocalizedMessage());
        }
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, new StringBuffer("Using forced coordinate reference system ").append(this.crs.toWKT()).toString());
        } else if (this.config.getCoordsys() != null) {
            String srsString = this.config.getCoordsys();
            try {
                this.crs = CRS.decode((String)srsString, (boolean)false);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not find " + srsString, e);
                return;
            }
        } else {
            CoordinateReferenceSystem tempcrs = this.jdbcAccess.getLevelInfo(0).getCrs();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, new StringBuffer("Unable to find a CRS for this coverage, using a default one: ").append(this.crs.toWKT()).toString());
            } else {
                this.crs = tempcrs;
            }
        }
        if (this.jdbcAccess.getNumOverviews() == -1) {
            String msg = "No levels found fond for coverage: " + this.config.getCoverageName();
            LOGGER.severe(msg);
            throw new IOException(msg);
        }
        Envelope env = this.jdbcAccess.getLevelInfo(0).getEnvelope();
        if (env == null) {
            String msg = "Coverage: " + this.config.getCoverageName() + " is not caluclated";
            LOGGER.severe(msg);
            throw new IOException(msg);
        }
        this.originalEnvelope = new GeneralEnvelope((Rectangle2D)new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getMaxX() - env.getMinX(), env.getMaxY() - env.getMinY()));
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.highestRes = this.jdbcAccess.getLevelInfo(0).getResolution();
        this.numOverviews = this.jdbcAccess.getNumOverviews();
        this.overViewResolutions = new double[this.numOverviews][];
        for (int i = 0; i < this.numOverviews; ++i) {
            this.overViewResolutions[i] = this.jdbcAccess.getLevelInfo(i + 1).getResolution();
        }
        this.originalGridRange = new GridEnvelope2D(new Rectangle((int)Math.round(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
    }

    public ImageMosaicJDBCReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicJDBCFormat();
    }

    private void logRequestParams(GeneralParameterValue[] params) {
        LOGGER.info("----PARAMS START-------");
        for (int i = 0; i < params.length; ++i) {
            Parameter p = (Parameter)params[i];
            LOGGER.info(p.getDescriptor().getName().toString() + ": " + p.getValue());
        }
        LOGGER.info("----PARAMS END-------");
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        this.logRequestParams(params);
        ImageMosaicJDBCReaderState state = new ImageMosaicJDBCReaderState();
        Date start = new Date();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading mosaic from " + this.coverageName);
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        Color outputTransparentColor = (Color)ImageMosaicJDBCFormat.OUTPUT_TRANSPARENT_COLOR.getDefaultValue();
        Color backgroundColor = (Color)ImageMosaicJDBCFormat.BACKGROUND_COLOR.getDefaultValue();
        Rectangle dim = null;
        if (params != null) {
            for (GeneralParameterValue generalParameterValue : params) {
                Parameter param = (Parameter)generalParameterValue;
                if (param.getDescriptor().getName().getCode().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    state.setRequestedEnvelope((GeneralEnvelope)gg.getEnvelope());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (param.getDescriptor().getName().getCode().equals(ImageMosaicJDBCFormat.OUTPUT_TRANSPARENT_COLOR.getName().toString())) {
                    outputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (!param.getDescriptor().getName().getCode().equals(ImageMosaicJDBCFormat.BACKGROUND_COLOR.getName().toString())) continue;
                backgroundColor = (Color)param.getValue();
            }
        }
        GridCoverage2D coverage = this.loadTiles(backgroundColor, outputTransparentColor, dim, state);
        LOGGER.info("Mosaic Reader needs : " + (new Date().getTime() - start.getTime()) + " millisecs");
        return coverage;
    }

    private void transformRequestEnvelope(ImageMosaicJDBCReaderState state) throws DataSourceException {
        if (CRS.equalsIgnoreMetadata((Object)state.getRequestedEnvelope().getCoordinateReferenceSystem(), (Object)this.crs)) {
            state.setRequestEnvelopeTransformed(state.getRequestedEnvelope());
            return;
        }
        try {
            MathTransform transform = operationFactory.createOperation(state.getRequestedEnvelope().getCoordinateReferenceSystem(), this.crs).getMathTransform();
            if (transform.isIdentity()) {
                state.setRequestEnvelopeTransformed(state.getRequestedEnvelope());
                return;
            }
            state.setRequestEnvelopeTransformed(CRS.transform((MathTransform)transform, (org.opengis.geometry.Envelope)state.getRequestedEnvelope()));
            state.getRequestEnvelopeTransformed().setCoordinateReferenceSystem(this.crs);
            int indexX = this.indexOfX(this.crs);
            int indexY = this.indexOfY(this.crs);
            int indexRequestedX = this.indexOfX(state.getRequestedEnvelope().getCoordinateReferenceSystem());
            int indexRequestedY = this.indexOfY(state.getRequestedEnvelope().getCoordinateReferenceSystem());
            if (indexX == indexRequestedY && indexY == indexRequestedX) {
                state.setXAxisSwitch(true);
                Rectangle2D.Double tmp = new Rectangle2D.Double(state.getRequestEnvelopeTransformed().getMinimum(1), state.getRequestEnvelopeTransformed().getMinimum(0), state.getRequestEnvelopeTransformed().getSpan(1), state.getRequestEnvelopeTransformed().getSpan(0));
                state.setRequestEnvelopeTransformed(new GeneralEnvelope((Rectangle2D)tmp));
                state.getRequestEnvelopeTransformed().setCoordinateReferenceSystem(this.crs);
            } else if (indexX != indexRequestedX || indexY != indexRequestedY) {
                throw new DataSourceException("Unable to resolve the X Axis problem");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Reprojected envelope ").append(state.getRequestedEnvelope().toString()).append(" crs ").append(this.crs.toWKT()).toString());
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
        }
    }

    private GridCoverage2D loadTiles(Color backgroundColor, Color outputTransparentColor, Rectangle pixelDimension, ImageMosaicJDBCReaderState state) throws IOException {
        Integer imageChoice;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Creating mosaic to comply with envelope ").append(state.getRequestedEnvelope() != null ? state.getRequestedEnvelope().toString() : null).append(" crs ").append(this.crs.toWKT()).append(" dim ").append(pixelDimension == null ? " null" : pixelDimension.toString()).toString());
        }
        this.transformRequestEnvelope(state);
        if (!state.getRequestEnvelopeTransformed().intersects((org.opengis.geometry.Envelope)this.originalEnvelope, true)) {
            LOGGER.warning("The requested envelope does not intersect the envelope of this mosaic, result is a nodata image");
            LOGGER.warning(state.getRequestEnvelopeTransformed().toString());
            LOGGER.warning(this.originalEnvelope.toString());
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)this.getEmptyImage((int)pixelDimension.getWidth(), (int)pixelDimension.getHeight(), backgroundColor, outputTransparentColor), (org.opengis.geometry.Envelope)state.getRequestedEnvelope());
        }
        ImageReadParam readP = new ImageReadParam();
        if (pixelDimension != null) {
            try {
                imageChoice = this.setReadParams(OverviewPolicy.getDefaultPolicy(), readP, state.getRequestEnvelopeTransformed(), pixelDimension);
                readP.setSourceSubsampling(1, 1, 0, 0);
            }
            catch (TransformException e) {
                LOGGER.severe(e.getLocalizedMessage());
                return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)this.getEmptyImage((int)pixelDimension.getWidth(), (int)pixelDimension.getHeight(), backgroundColor, outputTransparentColor), (org.opengis.geometry.Envelope)state.getRequestedEnvelope());
            }
        } else {
            imageChoice = new Integer(0);
        }
        ImageLevelInfo info = this.jdbcAccess.getLevelInfo(imageChoice);
        LOGGER.info("Coverage " + info.getCoverageName() + " using spatial table " + info.getSpatialTableName() + ", image table " + info.getTileTableName());
        ImageComposerThread imageComposerThread = new ImageComposerThread(backgroundColor, outputTransparentColor, pixelDimension, state.getRequestEnvelopeTransformed(), info, state.getTileQueue(), this.config, state.isXAxisSwitch(), this.coverageFactory);
        imageComposerThread.start();
        this.jdbcAccess.startTileDecoders(pixelDimension, state.getRequestEnvelopeTransformed(), info, state.getTileQueue(), this.coverageFactory);
        try {
            imageComposerThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        GridCoverage2D result = imageComposerThread.getGridCoverage2D();
        return this.transformResult(result, pixelDimension, state);
    }

    private GridCoverage2D transformResult(GridCoverage2D coverage, Rectangle pixelDimension, ImageMosaicJDBCReaderState state) {
        if (state.getRequestEnvelopeTransformed() == state.getRequestedEnvelope()) {
            return coverage;
        }
        GridCoverage2D result = null;
        LOGGER.info("Image reprojection necessairy");
        result = (GridCoverage2D)Operations.DEFAULT.resample((Coverage)coverage, state.getRequestedEnvelope().getCoordinateReferenceSystem());
        return this.coverageFactory.create((CharSequence)result.getName(), result.getRenderedImage(), result.getEnvelope());
    }

    private BufferedImage getEmptyImage(int width, int height, Color backGroundcolor, Color outputTransparentColor) {
        BufferedImage emptyImage = new BufferedImage(width, height, DEFAULT_IMAGE_TYPE);
        Graphics2D g2D = (Graphics2D)emptyImage.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(backGroundcolor);
        g2D.fillRect(0, 0, emptyImage.getWidth(), emptyImage.getHeight());
        g2D.setColor(save);
        if (outputTransparentColor != null) {
            emptyImage = new RenderedImageAdapter(ImageUtilities.maskColor((Color)outputTransparentColor, (RenderedImage)emptyImage)).getAsBufferedImage();
        }
        return emptyImage;
    }

    private int indexOfY(CoordinateReferenceSystem crs) {
        return this.indexOf(crs, UPDirections);
    }

    private int indexOfX(CoordinateReferenceSystem crs) {
        return this.indexOf(crs, LEFTDirections);
    }

    private int indexOf(CoordinateReferenceSystem crs, Set<AxisDirection> direction) {
        CoordinateSystem cs = crs.getCoordinateSystem();
        for (int index = 0; index < cs.getDimension(); ++index) {
            CoordinateSystemAxis axis = cs.getAxis(index);
            if (!direction.contains(axis.getDirection())) continue;
            return index;
        }
        return -1;
    }

    static {
        DEFAULT_IMAGE_TYPE = 5;
    }
}

