/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.imagemosaic.jdbc.AbstractThread;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.ImageMosaicJDBCReader;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageComposerThread
extends AbstractThread {
    protected static final Logger LOGGER = Logging.getLogger((String)ImageComposerThread.class.getPackage().getName());
    protected GridCoverageFactory coverageFactory;
    private GridCoverage2D gridCoverage2D;
    private Color outputTransparentColor;
    private Color backgroundColor;
    private boolean xAxisSwitch;

    public ImageComposerThread(Color backgroundColor, Color outputTransparentColor, Rectangle pixelDimension, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, Config config, boolean xAxisSwitch, GridCoverageFactory coverageFactory) {
        super(pixelDimension, requestEnvelope, levelInfo, tileQueue, config);
        this.outputTransparentColor = outputTransparentColor;
        this.backgroundColor = backgroundColor;
        this.xAxisSwitch = xAxisSwitch;
        this.coverageFactory = coverageFactory;
    }

    private Dimension getStartDimension() {
        double width = this.pixelDimension.getWidth() / this.rescaleX;
        double height = this.pixelDimension.getHeight() / this.rescaleY;
        return new Dimension((int)Math.round(width), (int)Math.round(height));
    }

    private BufferedImage getStartImage(BufferedImage copyFrom) {
        Dimension dim = this.getStartDimension();
        int imageType = copyFrom.getType();
        if (imageType == 0) {
            imageType = ImageMosaicJDBCReader.DEFAULT_IMAGE_TYPE;
        }
        BufferedImage image = null;
        image = (imageType == 12 || imageType == 13) && copyFrom.getColorModel() instanceof IndexColorModel ? new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), imageType, (IndexColorModel)copyFrom.getColorModel()) : new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), imageType);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(this.backgroundColor);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    private BufferedImage getStartImage(int imageType) {
        Dimension dim = this.getStartDimension();
        if (imageType == 0) {
            imageType = ImageMosaicJDBCReader.DEFAULT_IMAGE_TYPE;
        }
        BufferedImage image = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), imageType);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(this.backgroundColor);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    @Override
    public void run() {
        BufferedImage image = null;
        Graphics2D g2D = null;
        TileQueueElement queueObject = null;
        try {
            while (!(queueObject = (TileQueueElement)this.tileQueue.take()).isEndElement()) {
                if (image == null) {
                    image = this.getStartImage(queueObject.getTileImage());
                    g2D = (Graphics2D)image.getGraphics();
                }
                int posx = (int)((queueObject.getEnvelope().getMinimum(0) - this.requestEnvelope.getMinimum(0)) / this.levelInfo.getResX());
                int posy = (int)((this.requestEnvelope.getMaximum(1) - queueObject.getEnvelope().getMaximum(1)) / this.levelInfo.getResY());
                g2D.drawImage(queueObject.getTileImage(), AffineTransform.getTranslateInstance(posx, posy), null);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (image == null) {
            image = this.getStartImage(ImageMosaicJDBCReader.DEFAULT_IMAGE_TYPE);
        }
        GeneralEnvelope resultEnvelope = null;
        if (this.xAxisSwitch) {
            Rectangle2D.Double tmp = new Rectangle2D.Double(this.requestEnvelope.getMinimum(1), this.requestEnvelope.getMinimum(0), this.requestEnvelope.getSpan(1), this.requestEnvelope.getSpan(0));
            resultEnvelope = new GeneralEnvelope((Rectangle2D)tmp);
            resultEnvelope.setCoordinateReferenceSystem(this.requestEnvelope.getCoordinateReferenceSystem());
        } else {
            resultEnvelope = this.requestEnvelope;
        }
        image = this.rescaleImage(image);
        if (this.outputTransparentColor == null) {
            this.gridCoverage2D = this.coverageFactory.create((CharSequence)this.config.getCoverageName(), (RenderedImage)image, (Envelope)resultEnvelope);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final mosaic");
            }
            RenderedImage result = ImageUtilities.maskColor((Color)this.outputTransparentColor, (RenderedImage)image);
            this.gridCoverage2D = this.coverageFactory.create((CharSequence)this.config.getCoverageName(), result, (Envelope)resultEnvelope);
        }
    }

    GridCoverage2D getGridCoverage2D() {
        return this.gridCoverage2D;
    }
}

