/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageLevelInfo
implements Comparable<ImageLevelInfo> {
    private boolean canImageIOReadFromInputStream;
    private CoordinateReferenceSystem crs;
    private Integer srsId;
    private String coverageName;
    private Double extentMinX;
    private Double extentMinY;
    private Double extentMaxX;
    private Double extentMaxY;
    private Double resX;
    private Double resY;
    private String tileTableName;
    private String spatialTableName;
    private Integer countFeature;
    private Integer countTiles;
    private double[] resolution = null;
    private Envelope envelope = null;

    ImageLevelInfo() {
    }

    String getCoverageName() {
        return this.coverageName;
    }

    void setCoverageName(String coverageName) {
        this.coverageName = coverageName;
    }

    Double getExtentMaxX() {
        return this.extentMaxX;
    }

    void setExtentMaxX(Double extentMaxX) {
        this.extentMaxX = extentMaxX;
        this.envelope = null;
    }

    Double getExtentMaxY() {
        return this.extentMaxY;
    }

    void setExtentMaxY(Double extentMaxY) {
        this.extentMaxY = extentMaxY;
        this.envelope = null;
    }

    Double getExtentMinX() {
        return this.extentMinX;
    }

    void setExtentMinX(Double extentMinX) {
        this.extentMinX = extentMinX;
        this.envelope = null;
    }

    Double getExtentMinY() {
        return this.extentMinY;
    }

    void setExtentMinY(Double extentMinY) {
        this.extentMinY = extentMinY;
        this.envelope = null;
    }

    Double getResX() {
        return this.resX;
    }

    void setResX(Double resX) {
        this.resX = resX;
        this.resolution = null;
    }

    Double getResY() {
        return this.resY;
    }

    void setResY(Double resY) {
        this.resY = resY;
        this.resolution = null;
    }

    String getSpatialTableName() {
        return this.spatialTableName;
    }

    void setSpatialTableName(String spatialTableName) {
        this.spatialTableName = spatialTableName;
    }

    String getTileTableName() {
        return this.tileTableName;
    }

    void setTileTableName(String tileTableName) {
        this.tileTableName = tileTableName;
    }

    public String toString() {
        return "Coverage: " + this.getCoverageName() + ":" + this.getSpatialTableName() + ":" + this.getTileTableName();
    }

    @Override
    public int compareTo(ImageLevelInfo other) {
        int res = 0;
        res = this.getCoverageName().compareTo(other.getCoverageName());
        if (res != 0) {
            return res;
        }
        res = this.getResX().compareTo(other.getResX());
        if (res != 0) {
            return res;
        }
        res = this.getResY().compareTo(other.getResY());
        if (res != 0) {
            return res;
        }
        return 0;
    }

    double[] getResolution() {
        if (this.resolution != null) {
            return this.resolution;
        }
        this.resolution = new double[2];
        if (this.getResX() != null) {
            this.resolution[0] = this.getResX();
        }
        if (this.getResY() != null) {
            this.resolution[1] = this.getResY();
        }
        return this.resolution;
    }

    Envelope getEnvelope() {
        if (this.envelope != null) {
            return this.envelope;
        }
        if (this.getExtentMaxX() == null || this.getExtentMaxY() == null || this.getExtentMinX() == null || this.getExtentMinY() == null) {
            return null;
        }
        this.envelope = new Envelope(this.getExtentMinX().doubleValue(), this.getExtentMaxX().doubleValue(), this.getExtentMinY().doubleValue(), this.getExtentMaxY().doubleValue());
        return this.envelope;
    }

    Integer getCountFeature() {
        return this.countFeature;
    }

    void setCountFeature(Integer countFeature) {
        this.countFeature = countFeature;
    }

    Integer getCountTiles() {
        return this.countTiles;
    }

    void setCountTiles(Integer countTiles) {
        this.countTiles = countTiles;
    }

    CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    boolean calculateResolutionNeeded() {
        return this.getResX() == null || this.getResY() == null;
    }

    boolean calculateExtentsNeeded() {
        return this.getExtentMaxX() == null || this.getExtentMaxY() == null || this.getExtentMinX() == null || this.getExtentMinY() == null;
    }

    String infoString() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(bout);
        w.print("Coveragename: ");
        w.println(this.getCoverageName());
        if (this.getCrs() != null) {
            w.print("CoordinateRefernceSystem: ");
            w.println(this.getCrs().getName());
        }
        if (this.getSrsId() != null) {
            w.print("SRS_ID: ");
            w.println(this.getSrsId());
        }
        w.print("Envelope: ");
        w.println(this.getEnvelope());
        w.print("Resolution X: ");
        w.println(this.getResX());
        w.print("Resolution Y: ");
        w.println(this.getResY());
        w.print("Tiletable: ");
        w.print(this.getTileTableName());
        if (this.getCountTiles() != null) {
            w.print(" #tiles: ");
            w.println(this.getCountTiles());
        }
        w.print("Spatialtable: ");
        w.print(this.getSpatialTableName());
        if (this.getCountFeature() != null) {
            w.print(" #geometries: ");
            w.println(this.getCountFeature());
        }
        w.close();
        return bout.toString();
    }

    Integer getSrsId() {
        return this.srsId;
    }

    void setSrsId(Integer srsId) {
        this.srsId = srsId;
    }

    boolean isImplementedAsTableSplit() {
        return !this.getSpatialTableName().equals(this.getTileTableName());
    }

    public boolean getCanImageIOReadFromInputStream() {
        return this.canImageIOReadFromInputStream;
    }

    public void setCanImageIOReadFromInputStream(boolean canImageIOReadFromInputStream) {
        this.canImageIOReadFromInputStream = canImageIOReadFromInputStream;
    }
}

