/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.DB2Dialect;
import org.geotools.gce.imagemosaic.jdbc.MySqlDialect;
import org.geotools.gce.imagemosaic.jdbc.OracleDialect;
import org.geotools.gce.imagemosaic.jdbc.PostgisDialect;
import org.geotools.gce.imagemosaic.jdbc.SpatialExtension;
import org.geotools.gce.imagemosaic.jdbc.UniversalDialect;

public abstract class DBDialect {
    protected DataSource dataSource;
    protected Config config;

    public DBDialect(Config config) {
        this.config = config;
    }

    static DBDialect getDBDialect(Config config) {
        SpatialExtension type = config.getSpatialExtension();
        if (type == null) {
            return null;
        }
        if (type == SpatialExtension.DB2) {
            return new DB2Dialect(config);
        }
        if (type == SpatialExtension.POSTGIS) {
            return new PostgisDialect(config);
        }
        if (type == SpatialExtension.MYSQL) {
            return new MySqlDialect(config);
        }
        if (type == SpatialExtension.UNIVERSAL) {
            return new UniversalDialect(config);
        }
        if (type == SpatialExtension.ORACLE) {
            return new OracleDialect(config);
        }
        return null;
    }

    protected abstract String getBLOBSQLType();

    protected abstract String getMultiPolygonSQLType();

    protected Config getConfig() {
        return this.config;
    }

    private DataSource getDataSource() throws Exception {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Config config = this.getConfig();
        this.dataSource = DataSourceFinder.getDataSource(config.getDataSourceParams());
        return this.dataSource;
    }

    protected Connection getConnection() throws Exception {
        Connection con = this.getDataSource().getConnection();
        con.setAutoCommit(false);
        return con;
    }

    String getDropTableStatement(String tableName) {
        return "drop table " + tableName;
    }

    protected String getUnregisterSpatialStatement(String tn) {
        return null;
    }

    protected String getRegisterSpatialStatement(String tn, String srs) {
        return null;
    }

    protected abstract String getCreateIndexStatement(String var1) throws Exception;

    String getDropIndexStatment(String tn) {
        return "drop index IX_" + tn;
    }

    protected String getDoubleSQLType() {
        return "DOUBLE";
    }

    String getCreateMasterStatement() throws Exception {
        Config config = this.getConfig();
        String doubleType = this.getDoubleSQLType();
        String statement = "CREATE TABLE " + config.getMasterTable();
        statement = statement + "(" + config.getCoverageNameAttribute() + " CHARACTER (64)  NOT NULL";
        statement = statement + "," + config.getSpatialTableNameAtribute() + " VARCHAR (256)  NOT NULL";
        statement = statement + "," + config.getTileTableNameAtribute() + " VARCHAR (256)  NOT NULL";
        statement = statement + "," + config.getResXAttribute() + " " + doubleType + "," + config.getResYAttribute() + " " + doubleType;
        statement = statement + "," + config.getMinXAttribute() + " " + doubleType + "," + config.getMinYAttribute() + " " + doubleType;
        statement = statement + "," + config.getMaxXAttribute() + " " + doubleType + "," + config.getMaxYAttribute() + " " + doubleType;
        statement = statement + ",CONSTRAINT MASTER_PK PRIMARY KEY (";
        statement = statement + config.getCoverageNameAttribute() + "," + config.getSpatialTableNameAtribute() + "," + config.getTileTableNameAtribute();
        statement = statement + "))";
        return statement;
    }

    String getCreateTileTableStatement(String tableName) throws Exception {
        String statement = "CREATE TABLE " + tableName;
        statement = statement + "(" + this.getConfig().getKeyAttributeNameInTileTable() + " CHAR(64) NOT NULL ";
        statement = statement + "," + this.getConfig().getBlobAttributeNameInTileTable() + " " + this.getBLOBSQLType();
        statement = statement + ",CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInTileTable();
        statement = statement + "))";
        return statement;
    }

    protected String getCreateSpatialTableStatement(String tableName) throws Exception {
        String statement = "CREATE TABLE " + tableName;
        statement = statement + " ( " + this.getConfig().getKeyAttributeNameInSpatialTable() + " CHAR(64) NOT NULL, " + this.getConfig().getGeomAttributeNameInSpatialTable() + " " + this.getMultiPolygonSQLType() + " NOT NULL ";
        statement = statement + ",CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInSpatialTable();
        statement = statement + "))";
        return statement;
    }

    protected String getCreateSpatialTableStatementJoined(String tableName) throws Exception {
        String statement = "CREATE TABLE " + tableName;
        statement = statement + " ( " + this.getConfig().getKeyAttributeNameInSpatialTable() + " CHAR(64) NOT NULL, " + this.getConfig().getGeomAttributeNameInSpatialTable() + " " + this.getMultiPolygonSQLType() + " NOT NULL ";
        statement = statement + "," + this.getConfig().getBlobAttributeNameInTileTable() + " " + this.getBLOBSQLType();
        statement = statement + ",CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInSpatialTable();
        statement = statement + "))";
        return statement;
    }
}

