/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class ImageMosaicFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicFormat.class.toString());
    private static final String SUGGESTED_TILESIZE = "SUGGESTED_TILE_SIZE";
    public static final DefaultParameterDescriptor<String> SUGGESTED_TILE_SIZE = new DefaultParameterDescriptor("SUGGESTED_TILE_SIZE", String.class, null, (Object)"512,512");
    public static final String TILE_SIZE_SEPARATOR = ",";
    public static final ParameterDescriptor<Boolean> FADING = new DefaultParameterDescriptor("Fading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Color> INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("InputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Color> OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Double> INPUT_IMAGE_THRESHOLD_VALUE = new DefaultParameterDescriptor("InputImageThresholdValue", Double.class, null, (Object)new Double(Double.NaN));
    public static final ParameterDescriptor<Integer> MAX_ALLOWED_TILES = new DefaultParameterDescriptor("MaxAllowedTiles", Integer.class, null, (Object)Integer.MAX_VALUE);
    public static final ParameterDescriptor<Boolean> ALLOW_MULTITHREADING = new DefaultParameterDescriptor("AllowMultithreading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor("BackgroundValues", double[].class, null, null);

    public ImageMosaicFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaic");
        info.put("description", "Image mosaicking plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, INPUT_IMAGE_THRESHOLD_VALUE, OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ALLOW_MULTITHREADING, MAX_ALLOWED_TILES}));
        this.writeParameters = null;
    }

    public ImageMosaicReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object source) {
        try {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            sourceURL = ImageMosaicUtils.checkSource(source);
                            if (sourceURL == null) {
                                return false;
                            }
                            tileIndexStore = null;
                            crs = null;
                            try {
                                tileIndexStore = new ShapefileDataStore(sourceURL);
                                typeNames = tileIndexStore.getTypeNames();
                                if (typeNames.length <= 0) {
                                    var6_7 = false;
                                    var14_9 = null;
                                    break block16;
                                }
                                typeName = typeNames[0];
                                featureSource = tileIndexStore.getFeatureSource(typeName);
                                schema = (SimpleFeatureType)featureSource.getSchema();
                                crs = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
                                propsUrl = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
                                try {
                                    propsUrl.openStream().close();
                                }
                                catch (Exception e) {
                                    throw new FileNotFoundException(".properties file, descibing the ImageMoasic, cant be opened:" + propsUrl);
                                }
                                props = ImageMosaicUtils.loadPropertiesFile(sourceURL, crs, "location");
                                if (props == null) {
                                    var11_24 = false;
                                    break block17;
                                }
                                locationAttributeName = props.getLocationAttribute();
                                if (schema.getDescriptor(locationAttributeName) == null) {
                                    var12_26 = false;
                                    break block18;
                                }
                                var12_27 = true;
                                break block19;
                            }
                            catch (Throwable var13_28) {
                                var14_13 = null;
                                try {
                                    if (tileIndexStore == null) throw var13_28;
                                    tileIndexStore.dispose();
                                    throw var13_28;
                                }
                                catch (Throwable e) {
                                    if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) throw var13_28;
                                    ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                throw var13_28;
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [6 : 214->225)] { 
lbl51:
                        // 1 sources

                        if (tileIndexStore == null) return var6_7;
                        tileIndexStore.dispose();
                        return var6_7;
lbl54:
                        // 1 sources

                        catch (Throwable e) {
                            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var6_7;
                            ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                        return var6_7;
                    }
                    var14_10 = null;
                    ** try [egrp 3[TRYBLOCK] [6 : 214->225)] { 
lbl61:
                    // 1 sources

                    if (tileIndexStore == null) return var11_24;
                    tileIndexStore.dispose();
                    return var11_24;
lbl64:
                    // 1 sources

                    catch (Throwable e) {
                        if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var11_24;
                        ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    return var11_24;
                }
                var14_11 = null;
                ** try [egrp 3[TRYBLOCK] [6 : 214->225)] { 
lbl71:
                // 1 sources

                if (tileIndexStore == null) return var12_26;
                tileIndexStore.dispose();
                return var12_26;
lbl74:
                // 1 sources

                catch (Throwable e) {
                    if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var12_26;
                    ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return var12_26;
            }
            var14_12 = null;
            ** try [egrp 3[TRYBLOCK] [6 : 214->225)] { 
lbl81:
            // 1 sources

            if (tileIndexStore == null) return var12_27;
            tileIndexStore.dispose();
            return var12_27;
lbl84:
            // 1 sources

            catch (Throwable e) {
                if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var12_27;
                ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return var12_27;
        }
        catch (Throwable e) {
            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return false;
            ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImageMosaicReader getReader(Object source, Hints hints) {
        try {
            return new ImageMosaicReader(source, hints);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

