/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.util.ImagingException;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.Granule;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage2D gridCoverage;
    private RasterLayerRequest request;
    private GridCoverageFactory coverageFactory;
    private GeneralEnvelope coverageEnvelope;
    private URL inputURL;
    private boolean frozen = false;
    private RasterManager rasterManager;
    private String parentLocation;
    private Color finalTransparentColor;
    private ParameterBlockJAI pbjMosaic;
    private ReferencedEnvelope mosaicBBox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private int imageChoice = 0;
    private ImageReadParam baseReadParameters = new ImageReadParam();
    private boolean multithreadingAllowed = false;
    private boolean alphaIn = false;
    private MathTransform baseGridToWorld;
    private double[] backgroundValues;

    public RasterLayerResponse(RasterLayerRequest request, RasterManager rasterManager) {
        this.request = request;
        this.inputURL = rasterManager.getInputURL();
        try {
            this.parentLocation = DataUtilities.getParentUrl((URL)this.inputURL).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to determine the parent location of " + this.inputURL, e);
        }
        this.coverageEnvelope = rasterManager.getCoverageEnvelope();
        this.coverageFactory = rasterManager.getCoverageFactory();
        this.rasterManager = rasterManager;
        this.baseGridToWorld = rasterManager.getRaster2Model();
        this.finalTransparentColor = request.getOutputTransparentColor();
        this.multithreadingAllowed = request.isMultithreadingAllowed();
        this.backgroundValues = request.getBackgroundValues();
    }

    public GridCoverage2D createResponse() throws IOException {
        this.processRequest();
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.request;
    }

    private void processRequest() throws IOException {
        if (this.request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + this.request.toString());
            }
            this.gridCoverage = null;
            return;
        }
        if (this.frozen) {
            return;
        }
        RenderedImage mosaic = this.prepareResponse();
        RenderedImage finalRaster = this.postProcessRaster(mosaic);
        this.gridCoverage = this.prepareCoverage(finalRaster);
        this.frozen = true;
    }

    private RenderedImage postProcessRaster(RenderedImage mosaic) {
        if (this.finalTransparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final mosaic");
            }
            return ImageMosaicUtils.makeColorTransparent(this.finalTransparentColor, mosaic);
        }
        return mosaic;
    }

    private RenderedImage prepareResponse() throws DataSourceException {
        try {
            BoundingBox cropBBOX;
            this.pbjMosaic = new ParameterBlockJAI("Mosaic");
            this.pbjMosaic.setParameter("backgroundValues", (Object)this.backgroundValues);
            if (this.request.isBlend()) {
                this.pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_BLEND);
            } else {
                this.pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            }
            this.imageChoice = this.request.getRequestedBBox() != null && this.request.getRequestedRasterArea() != null ? this.setReadParams(this.request.getOverviewPolicy(), this.baseReadParameters, this.request) : 0;
            assert (this.imageChoice >= 0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(this.imageChoice).append(" with subsampling factors ").append(this.baseReadParameters.getSourceXSubsampling()).append(" ").append(this.baseReadParameters.getSourceYSubsampling()).toString());
            }
            this.mosaicBBox = (cropBBOX = this.request.getCropBBox()) != null ? ReferencedEnvelope.reference((BoundingBox)cropBBOX) : new ReferencedEnvelope((org.opengis.geometry.Envelope)this.coverageEnvelope);
            AffineTransform g2w = new AffineTransform((AffineTransform)this.baseGridToWorld);
            g2w.concatenate(ImageMosaicUtils.CENTER_TO_CORNER);
            RasterManager.OverviewLevel level = this.rasterManager.overviewsController.resolutionsLevels.get(this.imageChoice);
            RasterManager.OverviewLevel baseLevel = this.rasterManager.overviewsController.resolutionsLevels.get(0);
            AffineTransform2D adjustments = new AffineTransform2D(level.resolutionX / baseLevel.resolutionX * (double)this.baseReadParameters.getSourceXSubsampling(), 0.0, 0.0, level.resolutionY / baseLevel.resolutionY * (double)this.baseReadParameters.getSourceYSubsampling(), 0.0, 0.0);
            g2w.concatenate((AffineTransform)adjustments);
            this.finalGridToWorldCorner = new AffineTransform2D(g2w);
            this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
            this.rasterBounds = new GeneralGridEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)this.finalWorldToGridCorner, (org.opengis.geometry.Envelope)this.mosaicBBox), PixelInCell.CELL_CORNER, false).toRectangle();
            GranuleIndexVisitor visitor = new GranuleIndexVisitor();
            this.rasterManager.getFeaturesFromIndex((Envelope)this.mosaicBBox, visitor);
            visitor.produce();
            if (visitor.granulesNumber >= 1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loaded bbox " + this.mosaicBBox.toString() + " while crop bbox " + this.request.getCropBBox().toString());
                }
                return this.buildMosaic();
            }
            if (this.backgroundValues == null) {
                return ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])new Byte[]{(byte)0}, (RenderingHints)this.rasterManager.getHints());
            }
            Number[] values = new Double[this.backgroundValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.backgroundValues[i];
            }
            return ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])values, (RenderingHints)this.rasterManager.getHints());
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to create this mosaic", (Throwable)e);
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to create this mosaic", (Throwable)e);
        }
    }

    private RenderedImage processGranuleRaster(RenderedImage granule, int granuleIndex, int[] alphaIndex, boolean alphaIn, PlanarImage[] alphaChannels, boolean doTransparentColor, Color transparentColor) {
        if (this.rasterManager.expandMe && granule.getColorModel() instanceof IndexColorModel) {
            granule = new ImageWorker(granule).forceComponentColorModel().getRenderedImage();
        }
        if (doTransparentColor) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on input image number " + granuleIndex);
            }
            granule = ImageMosaicUtils.makeColorTransparent(transparentColor, granule);
            alphaIndex[0] = granule.getColorModel().getNumComponents() - 1;
        }
        if (alphaIn || doTransparentColor) {
            ImageWorker w = new ImageWorker(granule);
            if (granule.getSampleModel() instanceof MultiPixelPackedSampleModel) {
                w.forceComponentColorModel();
            }
            alphaChannels[granuleIndex] = granule.getColorModel() instanceof IndexColorModel ? w.forceComponentColorModel().retainLastBand().getPlanarImage() : w.retainBands(alphaIndex).getPlanarImage();
        }
        return granule;
    }

    private RenderedImage buildMosaic() throws IOException {
        ImageLayout layout = new ImageLayout(this.rasterBounds.x, this.rasterBounds.y, this.rasterBounds.width, this.rasterBounds.height);
        Dimension tileDimensions = this.request.getTileDimensions();
        if (tileDimensions != null) {
            layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp mosaic = JAI.create((String)"Mosaic", (ParameterBlock)this.pbjMosaic, (RenderingHints)hints);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Mosaic created ").toString());
        }
        return mosaic;
    }

    private GridCoverage2D prepareCoverage(RenderedImage image) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension((CharSequence)colorInterpretation.name()).geophysics(true);
        }
        return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), image, (org.opengis.geometry.Envelope)new GeneralEnvelope((org.opengis.geometry.Envelope)this.mosaicBBox), bands, null, null);
    }

    private int setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readParams, RasterLayerRequest request) throws IOException, TransformException {
        int imageChoice = 0;
        readParams.setSourceSubsampling(1, 1, 0, 0);
        OverviewPolicy policy = overviewPolicy == null ? this.rasterManager.overviewPolicy : overviewPolicy;
        if (policy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        imageChoice = this.rasterManager.overviewsController.pickOverviewLevel(overviewPolicy, request);
        this.rasterManager.decimationController.performDecimation(imageChoice, readParams, request);
        return imageChoice;
    }

    class GranuleIndexVisitor
    implements ItemVisitor {
        private final List<Future<RenderedImage>> tasks = new ArrayList<Future<RenderedImage>>();
        private int granulesNumber;
        private boolean doInputTransparency;
        private List<ROI> rois = new ArrayList<ROI>();
        private Color inputTransparentColor;
        private PlanarImage[] alphaChannels;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitItem(Object item) {
            URL rasterFile;
            SimpleFeature feature = (SimpleFeature)item;
            String granuleLocation = (String)feature.getAttribute(RasterLayerResponse.this.rasterManager.getLocationAttribute());
            ReferencedEnvelope granuleBBox = ReferencedEnvelope.reference((BoundingBox)feature.getBounds());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("About to read image number " + this.granulesNumber);
            }
            if ((rasterFile = RasterLayerResponse.this.rasterManager.getPathType().resolvePath(RasterLayerResponse.this.parentLocation, granuleLocation)) == null) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("File found " + granuleLocation);
            }
            Granule granule = null;
            SoftValueHashMap<String, Granule> softValueHashMap = ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache;
            synchronized (softValueHashMap) {
                if (((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.containsKey((Object)rasterFile.toString())) {
                    granule = (Granule)((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.get((Object)rasterFile.toString());
                } else {
                    granule = new Granule((BoundingBox)granuleBBox, rasterFile);
                    ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.put((Object)rasterFile.toString(), (Object)granule);
                }
            }
            GranuleLoader loader = new GranuleLoader(RasterLayerResponse.this.baseReadParameters, RasterLayerResponse.this.imageChoice, RasterLayerResponse.this.mosaicBBox, RasterLayerResponse.this.finalWorldToGridCorner, granule, RasterLayerResponse.this.request.getTileDimensions());
            if (!RasterLayerResponse.this.multithreadingAllowed) {
                this.tasks.add(new FutureTask<RenderedImage>(loader));
            } else {
                this.tasks.add(ImageMosaicReader.multiThreadedLoader.submit(loader));
            }
            ++this.granulesNumber;
            if (this.granulesNumber > RasterLayerResponse.this.request.getMaximumNumberOfGranules()) {
                throw new IllegalStateException("The maximum number of allowed granules (" + RasterLayerResponse.this.request.getMaximumNumberOfGranules() + ")has been exceeded.");
            }
        }

        public void produce() {
            this.alphaChannels = new PlanarImage[this.granulesNumber];
            int granuleIndex = 0;
            this.inputTransparentColor = RasterLayerResponse.this.request.getInputTransparentColor();
            this.doInputTransparency = this.inputTransparentColor != null;
            boolean firstGranule = true;
            int[] alphaIndex = null;
            for (Future<RenderedImage> future : this.tasks) {
                RenderedImage loadedImage;
                block13: {
                    try {
                        if (!RasterLayerResponse.this.multithreadingAllowed) {
                            FutureTask task = (FutureTask)future;
                            task.run();
                        }
                        if ((loadedImage = future.get()) == null) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Unable to load the raster for granule " + granuleIndex + " with request " + RasterLayerResponse.this.request.toString());
                            continue;
                        }
                        if (!firstGranule) break block13;
                        ColorModel cm = loadedImage.getColorModel();
                        RasterLayerResponse.this.alphaIn = cm.hasAlpha();
                        if (RasterLayerResponse.this.alphaIn || this.doInputTransparency) {
                            alphaIndex = new int[]{cm.getNumComponents() - 1};
                        }
                        RasterLayerResponse.this.pbjMosaic.setParameter("sourceThreshold", (Object)new double[][]{{ImageMosaicUtils.getThreshold(loadedImage.getSampleModel().getDataType())}});
                        firstGranule = false;
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granule " + granuleIndex, e);
                        continue;
                    }
                    catch (ExecutionException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granule " + granuleIndex, e);
                        continue;
                    }
                    catch (com.sun.media.jai.codecimpl.util.ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Adding to mosaic image number " + granuleIndex + " failed, original request was " + RasterLayerResponse.this.request);
                        continue;
                    }
                    catch (ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Adding to mosaic image number " + granuleIndex + " failed, original request was " + RasterLayerResponse.this.request);
                        continue;
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding to mosaic image number " + granuleIndex);
                }
                RenderedImage raster = RasterLayerResponse.this.processGranuleRaster(loadedImage, granuleIndex, alphaIndex, RasterLayerResponse.this.alphaIn, this.alphaChannels, this.doInputTransparency, this.inputTransparentColor);
                this.rois.add((ROI)new ROIShape((Shape)PlanarImage.wrapRenderedImage((RenderedImage)raster).getBounds()));
                RasterLayerResponse.this.pbjMosaic.addSource((Object)raster);
                ++granuleIndex;
            }
            this.granulesNumber = granuleIndex;
            if (this.granulesNumber == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load any granule ");
                }
                return;
            }
            if (RasterLayerResponse.this.alphaIn || this.doInputTransparency) {
                RasterLayerResponse.this.pbjMosaic.setParameter("sourceAlpha", (Object)this.alphaChannels);
            }
            RasterLayerResponse.this.pbjMosaic.setParameter("sourceROI", (Object)this.rois.toArray(new ROI[this.rois.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GranuleLoader
    implements Callable<RenderedImage> {
        final ReferencedEnvelope cropBBox;
        final MathTransform2D mosaicWorldToGrid;
        final Granule granule;
        final ImageReadParam readParameters;
        final int imageIndex;
        final Dimension tilesDimension;

        GranuleLoader(ImageReadParam readParameters, int imageIndex, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, Granule granule, Dimension tilesDimension) {
            this.readParameters = ImageMosaicUtils.cloneImageReadParam(readParameters);
            this.imageIndex = imageIndex;
            this.cropBBox = cropBBox;
            this.mosaicWorldToGrid = mosaicWorldToGrid;
            this.granule = granule;
            this.tilesDimension = tilesDimension != null ? (Dimension)tilesDimension.clone() : null;
        }

        public BoundingBox getCropBBox() {
            return this.cropBBox;
        }

        public MathTransform2D getMosaicWorldToGrid() {
            return this.mosaicWorldToGrid;
        }

        public Granule getGranule() {
            return this.granule;
        }

        public ImageReadParam getReadParameters() {
            return this.readParameters;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        @Override
        public RenderedImage call() throws Exception {
            return this.granule.loadRaster(this.readParameters, this.imageIndex, this.cropBBox, this.mosaicWorldToGrid, RasterLayerResponse.this.request, this.tilesDimension);
        }
    }
}

