/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class FeatureTypeHandler {
    private FIDMapperFactory fmFactory;
    protected Map featureTypeMap = new HashMap();
    protected Map featureTypeTimeoutMap = new HashMap();
    JDBC1DataStore dataStore;
    Map typeMappers = new HashMap();
    long cacheTimeOut;
    long lastTypeNameRequestTime;

    public FeatureTypeHandler(JDBC1DataStore store, FIDMapperFactory fmFactory, long cacheTimeOut) {
        this.dataStore = store;
        this.cacheTimeOut = cacheTimeOut;
        this.fmFactory = fmFactory;
    }

    public String[] getTypeNames() throws IOException {
        long now;
        long lastTime = this.lastTypeNameRequestTime;
        this.lastTypeNameRequestTime = now = System.currentTimeMillis();
        if (lastTime < now - this.cacheTimeOut || this.featureTypeMap.size() == 0) {
            String[] newTypeNames = this.loadTypeNamesFromDatabase();
            HashMap<String, FeatureTypeInfo> newFeatureTypeMap = new HashMap<String, FeatureTypeInfo>();
            for (int i = 0; i < newTypeNames.length; ++i) {
                String typeName = newTypeNames[i];
                FeatureTypeInfo info = (FeatureTypeInfo)this.featureTypeMap.get(typeName);
                newFeatureTypeMap.put(typeName, info);
            }
            this.featureTypeMap = newFeatureTypeMap;
            return newTypeNames;
        }
        Set keys = this.featureTypeMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void resetFIDMappers() {
        this.typeMappers.clear();
    }

    private String[] loadTypeNamesFromDatabase() throws IOException {
        int TABLE_NAME_COL = 3;
        Connection conn = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = this.dataStore.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE", "VIEW"};
            ResultSet tables = meta.getTables(null, this.dataStore.config.getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!this.dataStore.allowTable(tableName)) continue;
                list.add(tableName);
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
            conn = null;
            String message = "Error querying database for list of tables:" + sqlException.getMessage();
            throw new DataSourceException(message, (Throwable)sqlException);
        }
        finally {
            JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        }
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        FeatureTypeInfo info = this.getFeatureTypeInfo(typeName);
        return info.getSchema();
    }

    public FeatureTypeInfo getFeatureTypeInfo(String featureTypeName) throws IOException {
        long now = System.currentTimeMillis();
        Long ftInfoTime = (Long)this.featureTypeTimeoutMap.get(featureTypeName);
        FeatureTypeInfo info = (FeatureTypeInfo)this.featureTypeMap.get(featureTypeName);
        if (ftInfoTime == null || now - ftInfoTime > this.cacheTimeOut) {
            FIDMapper mapper = this.getFIDMapper(featureTypeName);
            SimpleFeatureType schema = this.dataStore.buildSchema(featureTypeName, mapper);
            info = new FeatureTypeInfo(featureTypeName, schema, mapper);
            for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
                if (!(ad instanceof GeometryDescriptor)) continue;
                int srid = this.dataStore.determineSRID(featureTypeName, ad.getLocalName());
                info.putSRID(ad.getLocalName(), srid);
            }
            if (this.cacheTimeOut > 0L) {
                this.featureTypeMap.put(featureTypeName, info);
                this.featureTypeTimeoutMap.put(featureTypeName, new Long(now));
            }
        }
        return info;
    }

    public FIDMapper getFIDMapper(String typeName) throws IOException {
        FIDMapper mapper = (FIDMapper)this.typeMappers.get(typeName);
        if (mapper != null) {
            return mapper;
        }
        mapper = this.dataStore.buildFIDMapper(typeName, this.fmFactory);
        if (mapper == null) {
            throw new RuntimeException("Could not build a FIDMapper for type " + typeName);
        }
        this.typeMappers.put(typeName, mapper);
        return mapper;
    }

    public void setFIDMapper(String typeName, FIDMapper mapper) {
        this.typeMappers.put(typeName, mapper);
    }

    public void forceRefresh() {
        this.lastTypeNameRequestTime = Long.MIN_VALUE;
        this.featureTypeMap.clear();
        this.featureTypeTimeoutMap.clear();
    }

    public FIDMapperFactory getFIDMapperFactory() {
        return this.fmFactory;
    }

    public void setFIDMapperFactory(FIDMapperFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("FIDMapper factory cannot be null");
        }
        this.fmFactory = factory;
    }
}

