/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCDataStoreTest
extends JDBCTestSupport {
    public void testGetNames() throws IOException {
        String[] typeNames = this.dataStore.getTypeNames();
        JDBCDataStoreTest.assertTrue((boolean)new HashSet<String>(Arrays.asList(typeNames)).contains(this.tname("ft1")));
    }

    public void testGetSchema() throws Exception {
        SimpleFeatureType ft1 = this.dataStore.getSchema(this.tname("ft1"));
        JDBCDataStoreTest.assertNotNull((Object)ft1);
        JDBCDataStoreTest.assertNotNull((Object)ft1.getDescriptor(this.aname("geometry")));
        JDBCDataStoreTest.assertNotNull((Object)ft1.getDescriptor(this.aname("intProperty")));
        JDBCDataStoreTest.assertNotNull((Object)ft1.getDescriptor(this.aname("doubleProperty")));
        JDBCDataStoreTest.assertNotNull((Object)ft1.getDescriptor(this.aname("stringProperty")));
        JDBCDataStoreTest.assertTrue((boolean)Geometry.class.isAssignableFrom(ft1.getDescriptor(this.aname("geometry")).getType().getBinding()));
        JDBCDataStoreTest.assertTrue((boolean)Number.class.isAssignableFrom(ft1.getDescriptor(this.aname("intProperty")).getType().getBinding()));
        JDBCDataStoreTest.assertEquals(Double.class, (Object)ft1.getDescriptor(this.aname("doubleProperty")).getType().getBinding());
        JDBCDataStoreTest.assertEquals(String.class, (Object)ft1.getDescriptor(this.aname("stringProperty")).getType().getBinding());
    }

    public void testCreateSchema() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("dateProperty"), Date.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        this.assertEqualsLax(ft2, featureType);
        JDBCDataStoreTest.assertNotSame((Object)ft2, (Object)featureType);
        Connection cx = this.dataStore.createConnection();
        Statement st = cx.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM ");
            if (this.dataStore.getDatabaseSchema() != null) {
                this.dataStore.getSQLDialect().encodeSchemaName(this.dataStore.getDatabaseSchema(), sql);
                sql.append(".");
            }
            this.dataStore.getSQLDialect().encodeTableName("ft2", sql);
            rs = st.executeQuery(sql.toString());
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
            cx.close();
        }
    }

    public void testCreateSchemaWithConstraints() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.nillable(false).add(this.aname("intProperty"), Integer.class);
        builder.length(5).add(this.aname("stringProperty"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("ft2"), Transaction.AUTO_COMMIT);
        w.hasNext();
        SimpleFeature f = (SimpleFeature)w.next();
        f.setAttribute(1, (Object)new Integer(0));
        f.setAttribute(2, (Object)"hello");
        w.write();
        w.hasNext();
        f = (SimpleFeature)w.next();
        f.setAttribute(1, null);
        try {
            w.write();
            JDBCDataStoreTest.fail((String)"null value for intProperty should have failed");
        }
        catch (Exception e) {
            // empty catch block
        }
        f.setAttribute(1, (Object)new Integer(1));
        f.setAttribute(2, (Object)"hello!");
        try {
            w.write();
            JDBCDataStoreTest.fail((String)"string greather than 5 chars should have failed");
        }
        catch (Exception e) {
            // empty catch block
        }
        w.close();
    }

    void assertEqualsLax(SimpleFeatureType e, SimpleFeatureType a) {
        if (e.equals(a)) {
            return;
        }
        JDBCDataStoreTest.assertEquals((int)e.getAttributeCount(), (int)a.getAttributeCount());
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            AttributeDescriptor att1 = e.getDescriptor(i);
            AttributeDescriptor att2 = a.getDescriptor(i);
            JDBCDataStoreTest.assertEquals((Object)att1.getName(), (Object)att2.getName());
            JDBCDataStoreTest.assertEquals((int)att1.getMinOccurs(), (int)att2.getMinOccurs());
            JDBCDataStoreTest.assertEquals((int)att1.getMaxOccurs(), (int)att2.getMaxOccurs());
            JDBCDataStoreTest.assertEquals((boolean)att1.isNillable(), (boolean)att2.isNillable());
            JDBCDataStoreTest.assertEquals((Object)att1.getDefaultValue(), (Object)att2.getDefaultValue());
            AttributeType t1 = att1.getType();
            AttributeType t2 = att2.getType();
            JDBCDataStoreTest.assertEquals((Object)t1.getName(), (Object)t2.getName());
            JDBCDataStoreTest.assertEquals((Object)t1.getDescription(), (Object)t2.getDescription());
            JDBCDataStoreTest.assertEquals((Object)t1.getRestrictions(), (Object)t2.getRestrictions());
            if (t1.getBinding().equals(t2.getBinding())) continue;
            if (Number.class.isAssignableFrom(t1.getBinding())) {
                JDBCDataStoreTest.assertTrue((boolean)Number.class.isAssignableFrom(t2.getBinding()));
            }
            if (!Date.class.isAssignableFrom(t2.getBinding())) continue;
            JDBCDataStoreTest.assertTrue((boolean)Date.class.isAssignableFrom(t2.getBinding()));
        }
    }

    public void testGetFeatureSource() throws Exception {
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname("ft1"));
        JDBCDataStoreTest.assertNotNull((Object)featureSource);
    }

    public void testGetFeatureReader() throws Exception {
        SimpleFeature feature;
        int i;
        GeometryFactory gf = this.dataStore.getGeometryFactory();
        DefaultQuery query = new DefaultQuery(this.tname("ft1"));
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        for (i = 0; i < 3; ++i) {
            JDBCDataStoreTest.assertTrue((boolean)reader.hasNext());
            feature = (SimpleFeature)reader.next();
            JDBCDataStoreTest.assertNotNull((Object)feature);
            JDBCDataStoreTest.assertEquals((int)4, (int)feature.getAttributeCount());
            Point p = gf.createPoint(new Coordinate((double)i, (double)i));
            JDBCDataStoreTest.assertTrue((boolean)p.equals((Geometry)feature.getAttribute(this.aname("geometry"))));
            Number ip = (Number)feature.getAttribute(this.aname("intProperty"));
            JDBCDataStoreTest.assertEquals((int)i, (int)ip.intValue());
        }
        JDBCDataStoreTest.assertFalse((boolean)reader.hasNext());
        reader.close();
        query.setPropertyNames(new String[]{this.aname("intProperty")});
        reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        for (i = 0; i < 3; ++i) {
            JDBCDataStoreTest.assertTrue((boolean)reader.hasNext());
            feature = (SimpleFeature)reader.next();
            JDBCDataStoreTest.assertEquals((int)1, (int)feature.getAttributeCount());
        }
        JDBCDataStoreTest.assertFalse((boolean)reader.hasNext());
        reader.close();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        query.setFilter((Filter)f);
        reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        for (int i2 = 0; i2 < 1; ++i2) {
            JDBCDataStoreTest.assertTrue((boolean)reader.hasNext());
            SimpleFeature feature2 = (SimpleFeature)reader.next();
        }
        JDBCDataStoreTest.assertFalse((boolean)reader.hasNext());
        reader.close();
    }

    public void testGetFeatureWriter() throws IOException {
        FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttribute(this.aname("stringProperty"), (Object)"foo");
            writer.write();
        }
        writer.close();
        DefaultQuery query = new DefaultQuery(this.tname("ft1"));
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCDataStoreTest.assertTrue((boolean)reader.hasNext());
        while (reader.hasNext()) {
            SimpleFeature feature = (SimpleFeature)reader.next();
            JDBCDataStoreTest.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
        }
        reader.close();
    }

    public void testGetFeatureWriterWithFilter() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(100));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures((Filter)f);
        JDBCDataStoreTest.assertEquals((int)0, (int)features.size());
        f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Filter)f, Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
            writer.write();
        }
        writer.close();
        f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(100));
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures((Filter)f);
        JDBCDataStoreTest.assertEquals((int)1, (int)features.size());
    }

    public void testGetFeatureWriterAppend() throws IOException {
        FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), Transaction.AUTO_COMMIT);
        for (int i = 3; i < 6; ++i) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttribute(this.aname("intProperty"), (Object)new Integer(i));
            writer.write();
        }
        writer.close();
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        JDBCDataStoreTest.assertEquals((int)6, (int)features.size());
    }
}

